/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.misc;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.math3.fitting.PolynomialCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoint;

public class Polynomial {
    public static double[] polyfit(double[] x, double[] y, int degree) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("X and Y must be of same length");
        }
        PolynomialCurveFitter pcf = PolynomialCurveFitter.create((int)degree);
        ArrayList<WeightedObservedPoint> points = new ArrayList<WeightedObservedPoint>();
        for (int i = 0; i < x.length; ++i) {
            points.add(new WeightedObservedPoint(1.0, x[i], y[i]));
        }
        return UtilMethods.reverse(pcf.fit(points));
    }

    public static double[] polyval(double[] coefficients, double[] x) {
        int degree = coefficients.length - 1;
        double[] y = new double[x.length];
        Arrays.fill(y, 0.0);
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < coefficients.length; ++j) {
                y[i] = y[i] + coefficients[j] * Math.pow(x[i], degree - j);
            }
        }
        return y;
    }

    public static double polyval(double[] coefficients, double x) {
        int degree = coefficients.length - 1;
        double y = 0.0;
        for (int j = 0; j < coefficients.length; ++j) {
            y += coefficients[j] * Math.pow(x, degree - j);
        }
        return y;
    }

    public static double[] polyder(double[] p, int m) {
        if (m > p.length || m < 0) {
            throw new IllegalArgumentException("m should be greater than 0 and less than number of polynomial coefficients");
        }
        double[] p_holder = p;
        for (int i = 0; i < m; ++i) {
            double[] der = new double[p_holder.length - 1];
            for (int j = 0; j < der.length; ++j) {
                der[j] = p_holder[j] * (double)(p_holder.length - j - 1);
            }
            p_holder = der;
        }
        return p_holder;
    }

    public static double[] polyint(double[] p, int m) {
        if (m > p.length || m < 0) {
            throw new IllegalArgumentException("m should be greater than 0 and less than number of polynomial coefficients");
        }
        double[] p_holder = p;
        for (int i = 0; i < m; ++i) {
            double[] integral = new double[p_holder.length + 1];
            for (int j = 0; j < p_holder.length; ++j) {
                integral[j] = p_holder[j] / (double)(p_holder.length - j);
            }
            integral[integral.length - 1] = 0.0;
            p_holder = integral;
        }
        return p_holder;
    }

    public static double[] polyint(double[] p, int m, double[] constants) {
        if (m > p.length || m < 0) {
            throw new IllegalArgumentException("m should be greater than 0 and less than number of polynomial coefficients");
        }
        if (constants.length < m) {
            throw new IllegalArgumentException("Number of integration constants should be at least equal to the degree of anti-derivative");
        }
        double[] p_holder = p;
        for (int i = 0; i < m; ++i) {
            double[] integral = new double[p_holder.length + 1];
            for (int j = 0; j < p_holder.length; ++j) {
                integral[j] = p_holder[j] / (double)(p_holder.length - j);
            }
            integral[integral.length - 1] = constants[i];
            p_holder = integral;
        }
        return p_holder;
    }
}

