/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.misc;

import org.apache.commons.math3.distribution.NormalDistribution;

public class Random {
    private long seed;
    private double mean = 0.0;
    private double sd = 1.0;
    private NormalDistribution nd = new NormalDistribution(this.mean, this.sd);
    private java.util.Random rd = new java.util.Random();

    public Random(long seed) {
        this.seed = seed;
        this.nd.reseedRandomGenerator(this.seed);
        this.rd.setSeed(this.seed);
    }

    public Random() {
        this.seed = 42L;
        this.nd.reseedRandomGenerator(this.seed);
        this.rd.setSeed(this.seed);
    }

    public void setSeed(long seed) {
        this.seed = seed;
        this.nd.reseedRandomGenerator(this.seed);
        this.rd.setSeed(this.seed);
    }

    public void setMeanAndSD(double mean, double sd) {
        this.mean = mean;
        this.sd = sd;
        this.nd = new NormalDistribution(this.mean, this.sd);
    }

    public double randomNormalSample() {
        return this.nd.sample();
    }

    public double[] randomNormal1D(int[] shape) {
        if (shape.length != 1) {
            throw new IllegalArgumentException("Shape must have exactly 1 item. Currently set to " + shape.length + ".");
        }
        double[] matrix = new double[shape[0]];
        for (int i = 0; i < shape[0]; ++i) {
            matrix[i] = this.nd.sample();
        }
        return matrix;
    }

    public double[][] randomNormal2D(int[] shape) {
        if (shape.length != 2) {
            throw new IllegalArgumentException("Shape must have exactly 2 items. Currently set to " + shape.length + ".");
        }
        double[][] matrix = new double[shape[0]][shape[1]];
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                matrix[i][j] = this.nd.sample();
            }
        }
        return matrix;
    }

    public double[][][] randomNormal3D(int[] shape) {
        if (shape.length != 3) {
            throw new IllegalArgumentException("Shape must have exactly 3 items. Currently set to " + shape.length + ".");
        }
        double[][][] matrix = new double[shape[0]][shape[1]][shape[2]];
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                for (int k = 0; k < shape[2]; ++k) {
                    matrix[i][j][k] = this.nd.sample();
                }
            }
        }
        return matrix;
    }

    public double randomDoubleSample() {
        return this.rd.nextDouble();
    }

    public double[] randomDouble1D(int[] shape) {
        if (shape.length != 1) {
            throw new IllegalArgumentException("Shape must have exactly 1 item. Currently set to " + shape.length + ".");
        }
        double[] matrix = new double[shape[0]];
        for (int i = 0; i < shape[0]; ++i) {
            matrix[i] = this.rd.nextDouble();
        }
        return matrix;
    }

    public double[][] randomDouble2D(int[] shape) {
        if (shape.length != 2) {
            throw new IllegalArgumentException("Shape must have exactly 2 items. Currently set to " + shape.length + ".");
        }
        double[][] matrix = new double[shape[0]][shape[1]];
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                matrix[i][j] = this.rd.nextDouble();
            }
        }
        return matrix;
    }

    public double[][][] randomDouble3D(int[] shape) {
        if (shape.length != 3) {
            throw new IllegalArgumentException("Shape must have exactly 3 items. Currently set to " + shape.length + ".");
        }
        double[][][] matrix = new double[shape[0]][shape[1]][shape[2]];
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                for (int k = 0; k < shape[2]; ++k) {
                    matrix[i][j][k] = this.rd.nextDouble();
                }
            }
        }
        return matrix;
    }

    public int randomIntSample(int upper_bound) {
        return this.rd.nextInt(++upper_bound);
    }

    public int randomIntSample(int lower_bound, int upper_bound) {
        if (lower_bound >= upper_bound) {
            throw new IllegalArgumentException("Upper bound must be less than lower bound");
        }
        return this.rd.nextInt(++upper_bound - lower_bound) + lower_bound;
    }

    public int[] randomInt1D(int[] shape, int upper_bound) {
        if (shape.length != 1) {
            throw new IllegalArgumentException("Shape must have exactly 1 item. Currently set to " + shape.length + ".");
        }
        ++upper_bound;
        int[] matrix = new int[shape[0]];
        for (int i = 0; i < shape[0]; ++i) {
            matrix[i] = this.rd.nextInt(upper_bound);
        }
        return matrix;
    }

    public int[] randomInt1D(int[] shape, int lower_bound, int upper_bound) {
        if (shape.length != 1) {
            throw new IllegalArgumentException("Shape must have exactly 1 item. Currently set to " + shape.length + ".");
        }
        if (lower_bound >= upper_bound) {
            throw new IllegalArgumentException("Upper bound must be less than lower bound");
        }
        ++upper_bound;
        int[] matrix = new int[shape[0]];
        for (int i = 0; i < shape[0]; ++i) {
            matrix[i] = this.rd.nextInt(upper_bound - lower_bound) + lower_bound;
        }
        return matrix;
    }

    public int[][] randomInt2D(int[] shape, int upper_bound) {
        if (shape.length != 2) {
            throw new IllegalArgumentException("Shape must have exactly 2 items. Currently set to " + shape.length + ".");
        }
        ++upper_bound;
        int[][] matrix = new int[shape[0]][shape[1]];
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                matrix[i][j] = this.rd.nextInt(upper_bound);
            }
        }
        return matrix;
    }

    public int[][] randomInt2D(int[] shape, int lower_bound, int upper_bound) {
        if (shape.length != 2) {
            throw new IllegalArgumentException("Shape must have exactly 2 items. Currently set to " + shape.length + ".");
        }
        if (lower_bound >= upper_bound) {
            throw new IllegalArgumentException("Upper bound must be less than lower bound");
        }
        ++upper_bound;
        int[][] matrix = new int[shape[0]][shape[1]];
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                matrix[i][j] = this.rd.nextInt(upper_bound - lower_bound) + lower_bound;
            }
        }
        return matrix;
    }

    public int[][][] randomInt3D(int[] shape, int upper_bound) {
        if (shape.length != 3) {
            throw new IllegalArgumentException("Shape must have exactly 3 items. Currently set to " + shape.length + ".");
        }
        ++upper_bound;
        int[][][] matrix = new int[shape[0]][shape[1]][shape[2]];
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                for (int k = 0; k < shape[2]; ++k) {
                    matrix[i][j][k] = this.rd.nextInt(upper_bound);
                }
            }
        }
        return matrix;
    }

    public int[][][] randomInt3D(int[] shape, int lower_bound, int upper_bound) {
        if (shape.length != 3) {
            throw new IllegalArgumentException("Shape must have exactly 3 items. Currently set to " + shape.length + ".");
        }
        if (lower_bound >= upper_bound) {
            throw new IllegalArgumentException("Upper bound must be less than lower bound");
        }
        ++upper_bound;
        int[][][] matrix = new int[shape[0]][shape[1]][shape[2]];
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                for (int k = 0; k < shape[2]; ++k) {
                    matrix[i][j][k] = this.rd.nextInt(upper_bound - lower_bound) + lower_bound;
                }
            }
        }
        return matrix;
    }
}

