/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.signal;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.signal.Convolution;

public class CrossCorrelation {
    private double[] signal;
    private double[] kernel;
    private double[] output;
    private boolean autocorr;

    public CrossCorrelation(double[] signal, double[] window) {
        this.signal = signal;
        this.kernel = window;
        this.autocorr = false;
    }

    public CrossCorrelation(double[] s) {
        this.signal = s;
        this.kernel = s;
        this.autocorr = true;
    }

    public double[] crossCorrelate() {
        String mode = "valid";
        if (this.autocorr) {
            mode = "full";
        }
        return this.crossCorrelate(mode);
    }

    public double[] crossCorrelate(String mode) {
        this.kernel = UtilMethods.reverse(this.kernel);
        Convolution c1 = new Convolution(this.signal, this.kernel);
        this.output = c1.convolve(mode);
        return this.output;
    }

    public double[] fastCrossCorrelate() {
        String mode = "valid";
        if (this.autocorr) {
            mode = "full";
        }
        return this.fastCrossCorrelate(mode);
    }

    public double[] fastCrossCorrelate(String mode) {
        this.kernel = UtilMethods.reverse(this.kernel);
        Convolution c1 = new Convolution(this.signal, this.kernel);
        this.output = c1.fastConvolve(mode);
        return this.output;
    }
}

