/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.signal;

import com.github.psambit9791.jdsp.signal.CrossCorrelation;
import java.util.Arrays;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.util.MathArrays;

public class Smooth {
    private double[] signal;
    private double[] smoothing_kernel;
    private double[] output;
    private String mode;

    public Smooth(double[] s, int wsize, String mode) throws IllegalArgumentException {
        this.signal = s;
        this.smoothing_kernel = new double[wsize];
        this.mode = mode;
        if (!mode.equals("rectangular") && !mode.equals("triangular")) {
            throw new IllegalArgumentException("Mode can only be rectangular or triangular.");
        }
        if (wsize > s.length) {
            throw new IllegalArgumentException("Kernel cannot be greater than signal.");
        }
        this.setKernel(this.mode);
    }

    private void setKernel(String type) {
        if (type.equals("rectangular")) {
            double value = 1.0 / (double)this.smoothing_kernel.length;
            Arrays.fill(this.smoothing_kernel, value);
        } else if (type.equals("triangular")) {
            int i;
            int iterator = 0;
            for (i = 1; i <= this.smoothing_kernel.length / 2; ++i) {
                this.smoothing_kernel[iterator] = i;
                ++iterator;
            }
            if (this.smoothing_kernel.length % 2 != 0) {
                this.smoothing_kernel[iterator] = Math.ceil((double)this.smoothing_kernel.length / 2.0);
                ++iterator;
            }
            for (i = this.smoothing_kernel.length / 2; i >= 1; --i) {
                this.smoothing_kernel[iterator] = i;
                ++iterator;
            }
        }
        double scaling_factor = 1.0 / StatUtils.sum((double[])this.smoothing_kernel);
        MathArrays.scaleInPlace((double)scaling_factor, (double[])this.smoothing_kernel);
    }

    public double[] smoothSignal() throws IllegalArgumentException {
        CrossCorrelation c = new CrossCorrelation(this.signal, this.smoothing_kernel);
        this.output = c.crossCorrelate("valid");
        return this.output;
    }

    public double[] smoothSignal(String correlation_mode) throws IllegalArgumentException {
        if (!(correlation_mode.equals("same") || correlation_mode.equals("valid") || correlation_mode.equals("full"))) {
            throw new IllegalArgumentException("Mode can only be same, valid or full.");
        }
        CrossCorrelation c = new CrossCorrelation(this.signal, this.smoothing_kernel);
        this.output = c.crossCorrelate(correlation_mode);
        return this.output;
    }

    public double[] getKernel() {
        return this.smoothing_kernel;
    }
}

