/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.signal.peaks;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.signal.peaks.Peak;
import com.github.psambit9791.jdsp.signal.peaks.Spike;
import java.util.ArrayList;
import java.util.LinkedList;

public class FindPeak {
    private double[] signal;
    private ArrayList<Integer> maxima_indices;
    private ArrayList<Integer> minima_indices;
    private int[] peak_indices = null;
    private int[] trough_indices = null;
    private int overlap = 3;
    private int threads = 4;

    public FindPeak(double[] s) {
        this.signal = s;
        this.maxima_indices = new ArrayList();
        this.minima_indices = new ArrayList();
    }

    private void reset_indices() {
        this.maxima_indices = new ArrayList();
        this.minima_indices = new ArrayList();
    }

    private boolean checkState(Thread[] threads) {
        for (Thread t : threads) {
            if (String.valueOf((Object)t.getState()).equals("TERMINATED")) continue;
            return false;
        }
        return true;
    }

    private int[] getSplitIndices(double[] signal, int threads) {
        int splitLength = signal.length / threads;
        int[] indices = new int[threads];
        int start_index = 0;
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = start_index;
            start_index = start_index + splitLength - this.overlap;
        }
        return indices;
    }

    private double[][] splitSignalByThreads(double[] signal, int threads) {
        int splitLength = signal.length / threads;
        double[][] splitData = new double[threads][];
        int start_index = 0;
        for (int i = 0; i < threads - 1; ++i) {
            int stop_index = start_index + splitLength;
            splitData[i] = UtilMethods.splitByIndex(signal, start_index, stop_index);
            start_index = stop_index - this.overlap;
        }
        splitData[threads - 1] = UtilMethods.splitByIndex(signal, start_index, signal.length);
        return splitData;
    }

    public int[] detectRelativeMaxima() {
        this.reset_indices();
        for (int i = 1; i < this.signal.length - 1; ++i) {
            if (!(this.signal[i - 1] < this.signal[i]) || !(this.signal[i + 1] < this.signal[i])) continue;
            this.maxima_indices.add(i);
        }
        return UtilMethods.convertToPrimitiveInt(this.maxima_indices);
    }

    public int[] detectRelativeMinima() {
        this.reset_indices();
        for (int i = 1; i < this.signal.length - 1; ++i) {
            if (!(this.signal[i - 1] > this.signal[i]) || !(this.signal[i + 1] > this.signal[i])) continue;
            this.minima_indices.add(i);
        }
        return UtilMethods.convertToPrimitiveInt(this.minima_indices);
    }

    public Peak detectPeaks() {
        Peak p = this.detect(this.signal, "peak");
        this.peak_indices = p.getPeaks();
        return p;
    }

    public Peak detectTroughs() {
        double[] reverse_signal = new double[this.signal.length];
        for (int i = 0; i < reverse_signal.length; ++i) {
            reverse_signal[i] = 0.0 - this.signal[i];
        }
        Peak p = this.detect(reverse_signal, "trough");
        this.trough_indices = p.getPeaks();
        return p;
    }

    private Peak detect(double[] signal, String mode) {
        LinkedList<Integer> midpoints = new LinkedList<Integer>();
        LinkedList<Integer> left_edge = new LinkedList<Integer>();
        LinkedList<Integer> right_edge = new LinkedList<Integer>();
        this.reset_indices();
        int i_max = signal.length - 1;
        int i_ahead = 0;
        for (int i = 1; i < i_max; ++i) {
            if (!(signal[i - 1] < signal[i])) continue;
            for (i_ahead = i + 1; i_ahead < i_max && signal[i_ahead] == signal[i]; ++i_ahead) {
            }
            if (!(signal[i_ahead] < signal[i])) continue;
            left_edge.add(i);
            right_edge.add(i_ahead - 1);
            midpoints.add((i + i_ahead - 1) / 2);
            i = i_ahead;
        }
        Peak pObj = new Peak(signal, UtilMethods.convertToPrimitiveInt(midpoints), UtilMethods.convertToPrimitiveInt(left_edge), UtilMethods.convertToPrimitiveInt(right_edge), mode);
        return pObj;
    }

    private int getClosest(int[] arr, int val, String mode) {
        int closest;
        block3: {
            block2: {
                closest = -1;
                if (!mode.equals("left")) break block2;
                int distance = -1000000;
                for (int i = 0; i < arr.length; ++i) {
                    if (arr[i] - val <= distance || arr[i] - val >= 0) continue;
                    distance = arr[i] - val;
                    closest = arr[i];
                }
                break block3;
            }
            if (!mode.equals("right")) break block3;
            int distance = 1000000;
            for (int i = arr.length - 1; i >= 0; --i) {
                if (arr[i] - val >= distance || arr[i] - val <= 0) continue;
                distance = arr[i] - val;
                closest = arr[i];
            }
        }
        return closest;
    }

    public Spike getSpikes(double[] signal, int[] peaks, int[] troughs) {
        int[] left_trough = new int[peaks.length];
        int[] right_trough = new int[peaks.length];
        for (int i = 0; i < peaks.length; ++i) {
            left_trough[i] = this.getClosest(troughs, peaks[i], "left");
            right_trough[i] = this.getClosest(troughs, peaks[i], "right");
        }
        Spike sObj = new Spike(signal, peaks, left_trough, right_trough);
        return sObj;
    }

    public Spike getSpikes() {
        if (this.peak_indices == null || this.trough_indices == null) {
            this.detectPeaks();
            this.detectTroughs();
        }
        return this.getSpikes(this.signal, this.peak_indices, this.trough_indices);
    }
}

