/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.transform;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.signal.ComplexConvolution;
import com.github.psambit9791.jdsp.signal.Convolution;
import com.github.psambit9791.jdsp.signal.Generate;
import org.apache.commons.math3.complex.Complex;

public class ContinuousWavelet {
    private double[] signal;
    private int[] widths;

    public ContinuousWavelet(double[] signal, int[] widths) {
        this.signal = signal;
        this.widths = widths;
    }

    private Complex[] ricker_cwt(double[] data, double[] wavelet) {
        Convolution c = new Convolution(data, wavelet);
        return UtilMethods.matToComplex(c.fastConvolve("same"));
    }

    private Complex[] morlet_cwt(double[] data, Complex[] wavelet) {
        Complex[] wavelet_conjugate = new Complex[wavelet.length];
        for (int i = 0; i < wavelet.length; ++i) {
            wavelet_conjugate[i] = wavelet[i].conjugate();
        }
        ComplexConvolution c1 = new ComplexConvolution(data, wavelet_conjugate);
        return c1.convolve("same");
    }

    private Complex[] paul_cwt(double[] data, Complex[] wavelet) {
        ComplexConvolution c1 = new ComplexConvolution(data, wavelet);
        return c1.convolve("same");
    }

    public Complex[][] transform(waveletType wavelet_type, double args) throws IllegalArgumentException {
        Complex[][] output = new Complex[this.widths.length][this.signal.length];
        switch (wavelet_type.ordinal()) {
            case 1: {
                for (int i = 0; i < this.widths.length; ++i) {
                    int N = Math.min(10 * this.widths[i], this.signal.length);
                    Generate gp = new Generate();
                    double[] wavelet = gp.generateRicker(N, this.widths[i]);
                    wavelet = UtilMethods.reverse(wavelet);
                    output[i] = this.ricker_cwt(this.signal, wavelet);
                }
                break;
            }
            case 0: {
                for (int i = 0; i < this.widths.length; ++i) {
                    int N = Math.min(10 * this.widths[i], this.signal.length);
                    Generate gp = new Generate();
                    Complex[] wavelet = gp.generateMorletCWTComplex(N, args, this.widths[i]);
                    wavelet = UtilMethods.reverse(wavelet);
                    output[i] = this.morlet_cwt(this.signal, wavelet);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.widths.length; ++i) {
                    Generate gp = new Generate();
                    double norm = Math.sqrt(1.0 / (double)this.widths[i]);
                    Complex[] wavelet = gp.generatePaulComplex((int)args, this.widths[i], this.widths[i]);
                    for (int w = 0; w < wavelet.length; ++w) {
                        wavelet[w] = wavelet[w].multiply(norm);
                    }
                    output[i] = this.paul_cwt(this.signal, wavelet);
                }
                break;
            }
            default: {
                throw new ArithmeticException("wavelet_type must be RICKER, MORLET or PAUL");
            }
        }
        return output;
    }

    public static enum waveletType {
        MORLET,
        RICKER,
        PAUL;

    }
}

