/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.transform;

import com.github.psambit9791.jdsp.transform._SineCosine;

public class DiscreteCosine
implements _SineCosine {
    private double[] signal;
    private double[] output = null;
    private _SineCosine.Normalization norm;

    public DiscreteCosine(double[] signal, _SineCosine.Normalization norm) {
        this.signal = signal;
        this.norm = norm;
    }

    public DiscreteCosine(double[] signal) {
        this.signal = signal;
        this.norm = _SineCosine.Normalization.STANDARD;
    }

    private double get_scaling_factor(int k, int type) {
        int N = this.signal.length;
        double factor = 0.0;
        if (type == 1) {
            factor = k == 0 || k == N - 1 ? 0.5 * Math.sqrt(1.0 / (double)(N - 1)) : 0.5 * Math.sqrt(2.0 / (double)(N - 1));
        } else if (type == 2) {
            factor = k == 0 ? Math.sqrt(1.0 / (double)(4 * N)) : Math.sqrt(1.0 / (double)(2 * N));
        } else if (type == 3) {
            factor = 1.0 / Math.sqrt(N);
        } else if (type == 4) {
            factor = 1.0 / Math.sqrt(2 * N);
        }
        return factor;
    }

    private double[] type1() {
        double[] out = new double[this.signal.length];
        double factor1 = 1.0;
        double factor2 = 1.0;
        if (this.norm == _SineCosine.Normalization.ORTHOGONAL) {
            factor1 = Math.sqrt(2.0);
        }
        for (int k = 0; k < out.length; ++k) {
            if (this.norm == _SineCosine.Normalization.ORTHOGONAL) {
                factor2 = this.get_scaling_factor(k, 1);
            }
            double temp0 = factor1 * this.signal[0];
            double temp1 = factor1 * Math.pow(-1.0, k) * this.signal[this.signal.length - 1];
            double sum = 0.0;
            for (int n = 1; n < this.signal.length - 1; ++n) {
                sum += this.signal[n] * Math.cos(Math.PI * (double)k * (double)n / (double)(this.signal.length - 1));
            }
            out[k] = factor2 * (temp0 + temp1 + 2.0 * sum);
        }
        return out;
    }

    private double[] type2() {
        double[] out = new double[this.signal.length];
        for (int k = 0; k < out.length; ++k) {
            double sum = 0.0;
            for (int n = 0; n < this.signal.length; ++n) {
                sum += this.signal[n] * Math.cos(Math.PI * (double)k * (double)(2 * n + 1) / (double)(2 * this.signal.length));
            }
            out[k] = this.norm == _SineCosine.Normalization.ORTHOGONAL ? this.get_scaling_factor(k, 2) * 2.0 * sum : 2.0 * sum;
        }
        return out;
    }

    private double[] type3() {
        double[] out = new double[this.signal.length];
        for (int k = 0; k < out.length; ++k) {
            double temp0 = this.signal[0];
            double sum = 0.0;
            for (int n = 1; n < this.signal.length; ++n) {
                sum += this.signal[n] * Math.cos(Math.PI * (double)(2 * k + 1) * (double)n / (double)(this.signal.length * 2));
            }
            out[k] = this.norm == _SineCosine.Normalization.ORTHOGONAL ? this.get_scaling_factor(k, 3) * (temp0 + Math.sqrt(2.0) * sum) : temp0 + 2.0 * sum;
        }
        return out;
    }

    private double[] type4() {
        double[] out = new double[this.signal.length];
        for (int k = 0; k < out.length; ++k) {
            double sum = 0.0;
            for (int n = 0; n < this.signal.length; ++n) {
                sum += this.signal[n] * Math.cos(Math.PI * (double)(2 * k + 1) * (double)(2 * n + 1) / (double)(4 * this.signal.length));
            }
            out[k] = this.norm == _SineCosine.Normalization.ORTHOGONAL ? this.get_scaling_factor(k, 4) * 2.0 * sum : 2.0 * sum;
        }
        return out;
    }

    @Override
    public void transform(int type) throws IllegalArgumentException {
        if (type <= 0 || type > 4) {
            throw new IllegalArgumentException("Type must be between 1 and 4");
        }
        switch (type) {
            case 1: {
                this.output = this.type1();
                break;
            }
            case 2: {
                this.output = this.type2();
                break;
            }
            case 3: {
                this.output = this.type3();
                break;
            }
            case 4: {
                this.output = this.type4();
            }
        }
    }

    @Override
    public void transform() {
        this.output = this.type1();
    }

    @Override
    public int getSignalLength() {
        return this.signal.length;
    }

    @Override
    public double[] getOutput() throws ExceptionInInitializerError {
        if (this.output == null) {
            throw new ExceptionInInitializerError("Execute transform() function before returning result");
        }
        return this.output;
    }
}

