/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.transform;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.transform._Fourier;
import java.util.Arrays;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.TransformType;

public class FastFourier
implements _Fourier {
    private double[] signal;
    private Complex[] output;
    private FastFourierTransformer ft;

    private void extendSignal() {
        double power = Math.log(this.signal.length) / Math.log(2.0);
        double raised_power = Math.ceil(power);
        int new_length = (int)Math.pow(2.0, raised_power);
        if (new_length != this.signal.length) {
            this.signal = UtilMethods.zeroPadSignal(this.signal, new_length - this.signal.length);
        }
    }

    @Override
    public int getSignalLength() {
        return this.signal.length;
    }

    @Override
    public double[] getFFTFreq(int Fs, boolean onlyPositive) {
        double[] results;
        if (this.output == null) {
            throw new ExceptionInInitializerError("Execute transform() function before returning FFT bins");
        }
        double val = (double)Fs / (double)this.signal.length;
        if (onlyPositive) {
            int N = this.signal.length / 2 + 1;
            int[] p1 = UtilMethods.arange(0, N, 1);
            results = Arrays.stream(p1).asDoubleStream().toArray();
        } else {
            int N = (this.signal.length - 1) / 2 + 1;
            int[] p1 = UtilMethods.arange(0, N, 1);
            int[] p2 = UtilMethods.arange(-(this.signal.length / 2), 0, 1);
            results = Arrays.stream(UtilMethods.concatenateArray(p1, p2)).asDoubleStream().toArray();
        }
        results = UtilMethods.scalarArithmetic(results, val, "mul");
        return results;
    }

    public FastFourier(double[] signal) {
        this.signal = signal;
        this.extendSignal();
        this.ft = new FastFourierTransformer(DftNormalization.STANDARD);
    }

    public FastFourier(double[] signal, DftNormalization norm) {
        this.signal = signal;
        this.extendSignal();
        this.ft = new FastFourierTransformer(norm);
    }

    @Override
    public void transform() {
        this.output = this.ft.transform(this.signal, TransformType.FORWARD);
    }

    @Override
    public double[] getMagnitude(boolean onlyPositive) throws ExceptionInInitializerError {
        Complex[] dftout = this.getComplex(onlyPositive);
        return Arrays.stream(dftout).mapToDouble(Complex::abs).toArray();
    }

    @Override
    public double[] getPhaseRad(boolean onlyPositive) throws ExceptionInInitializerError {
        Complex[] dftout = this.getComplex(onlyPositive);
        return Arrays.stream(dftout).mapToDouble(Complex::getArgument).toArray();
    }

    @Override
    public double[] getPhaseDeg(boolean onlyPositive) throws ExceptionInInitializerError {
        double[] dftout = this.getPhaseRad(onlyPositive);
        return Arrays.stream(dftout).map(Math::toDegrees).toArray();
    }

    @Override
    public double[][] getMagPhaseRad(boolean onlyPositive) throws ExceptionInInitializerError {
        double[] dftMag = this.getMagnitude(onlyPositive);
        double[] dftPhase = this.getPhaseRad(onlyPositive);
        double[][] out = new double[dftMag.length][2];
        for (int i = 0; i < out.length; ++i) {
            out[i][0] = dftMag[i];
            out[i][1] = dftPhase[i];
        }
        return out;
    }

    @Override
    public double[][] getMagPhaseDeg(boolean onlyPositive) throws ExceptionInInitializerError {
        double[] dftMag = this.getMagnitude(onlyPositive);
        double[] dftPhase = this.getPhaseDeg(onlyPositive);
        double[][] out = new double[dftMag.length][2];
        for (int i = 0; i < out.length; ++i) {
            out[i][0] = dftMag[i];
            out[i][1] = dftPhase[i];
        }
        return out;
    }

    @Override
    public double[][] getComplex2D(boolean onlyPositive) throws ExceptionInInitializerError {
        Complex[] dftout = this.getComplex(onlyPositive);
        return UtilMethods.complexTo2D(dftout);
    }

    @Override
    public Complex[] getComplex(boolean onlyPositive) throws ExceptionInInitializerError {
        Complex[] dftout;
        if (this.output == null) {
            throw new ExceptionInInitializerError("Execute transform() function before returning result");
        }
        if (onlyPositive) {
            int numBins = this.output.length / 2 + 1;
            dftout = new Complex[numBins];
        } else {
            dftout = new Complex[this.output.length];
        }
        System.arraycopy(this.output, 0, dftout, 0, dftout.length);
        return dftout;
    }
}

