/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.transform;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.transform._SineCosine;
import org.apache.commons.math3.transform.DstNormalization;
import org.apache.commons.math3.transform.FastSineTransformer;
import org.apache.commons.math3.transform.TransformType;

public class FastSine
implements _SineCosine {
    private double[] signal;
    private double[] output;
    private FastSineTransformer fst;

    private void extendSignal() {
        double power = Math.log(this.signal.length) / Math.log(2.0);
        double raised_power = Math.ceil(power);
        int new_length = (int)Math.pow(2.0, raised_power);
        if (new_length != this.signal.length) {
            this.signal = UtilMethods.zeroPadSignal(this.signal, new_length - this.signal.length);
        }
    }

    public FastSine(double[] signal) {
        this.signal = signal;
        this.extendSignal();
        this.fst = new FastSineTransformer(DstNormalization.STANDARD_DST_I);
    }

    public FastSine(double[] signal, _SineCosine.Normalization norm) {
        this.signal = signal;
        this.extendSignal();
        this.fst = norm == _SineCosine.Normalization.ORTHOGONAL ? new FastSineTransformer(DstNormalization.ORTHOGONAL_DST_I) : new FastSineTransformer(DstNormalization.STANDARD_DST_I);
    }

    @Override
    public void transform(int type) throws IllegalArgumentException {
        if (type != 1) {
            throw new IllegalArgumentException("FastSine only has type 1 implementation");
        }
        this.output = this.fst.transform(this.signal, TransformType.FORWARD);
    }

    @Override
    public void transform() {
        this.output = this.fst.transform(this.signal, TransformType.FORWARD);
    }

    @Override
    public double[] getOutput() throws ExceptionInInitializerError {
        if (this.output == null) {
            throw new ExceptionInInitializerError("Execute transform() function before returning result");
        }
        return this.output;
    }

    @Override
    public int getSignalLength() {
        return this.signal.length;
    }
}

