/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.transform;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.transform.DiscreteFourier;
import com.github.psambit9791.jdsp.transform.FastFourier;
import com.github.psambit9791.jdsp.transform.InverseDiscreteFourier;
import com.github.psambit9791.jdsp.transform.InverseFastFourier;
import com.github.psambit9791.jdsp.transform._Fourier;
import com.github.psambit9791.jdsp.transform._InverseFourier;
import java.util.Arrays;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.util.FastMath;

public class Hilbert {
    private double[] signal;
    private double[] h;
    private Complex[] output = null;

    public Hilbert(double[] s) {
        this.signal = s;
    }

    private void fillH() {
        this.h[0] = 1.0;
        if (this.h.length % 2 == 0) {
            for (int i = 1; i < this.h.length / 2; ++i) {
                this.h[i] = 2.0;
            }
            this.h[this.h.length / 2] = 1.0;
        } else {
            for (int i = 0; i < (this.h.length + 1) / 2; ++i) {
                this.h[i] = 2.0;
            }
        }
    }

    public void transform() {
        _Fourier dft = this.signal.length > 200 ? new FastFourier(this.signal) : new DiscreteFourier(this.signal);
        this.h = new double[dft.getSignalLength()];
        Arrays.fill(this.h, 0.0);
        this.fillH();
        dft.transform();
        double[][] dftOut = dft.getComplex2D(false);
        double[][] modOut = new double[dftOut.length][dftOut[0].length];
        for (int i = 0; i < modOut.length; ++i) {
            modOut[i][0] = dftOut[i][0] * this.h[i];
            modOut[i][1] = dftOut[i][1] * this.h[i];
        }
        _InverseFourier idft = Math.log(modOut.length) % Math.log(2.0) == 0.0 ? new InverseFastFourier(UtilMethods.matToComplex(modOut), false) : new InverseDiscreteFourier(modOut, false);
        idft.transform();
        this.output = idft.getComplex();
    }

    public void transform(boolean forceDFT) {
        _Fourier dft;
        if (forceDFT) {
            dft = new DiscreteFourier(this.signal);
            this.h = new double[dft.getSignalLength()];
            Arrays.fill(this.h, 0.0);
            this.fillH();
        } else if (this.signal.length > 200) {
            dft = new FastFourier(this.signal);
            this.h = new double[dft.getSignalLength()];
            Arrays.fill(this.h, 0.0);
            this.fillH();
        } else {
            dft = new DiscreteFourier(this.signal);
            this.h = new double[dft.getSignalLength()];
            Arrays.fill(this.h, 0.0);
            this.fillH();
        }
        dft.transform();
        double[][] dftOut = dft.getComplex2D(false);
        double[][] modOut = new double[dftOut.length][dftOut[0].length];
        for (int i = 0; i < modOut.length; ++i) {
            modOut[i][0] = dftOut[i][0] * this.h[i];
            modOut[i][1] = dftOut[i][1] * this.h[i];
        }
        _InverseFourier idft = forceDFT ? new InverseDiscreteFourier(modOut, false) : (Math.log(modOut.length) % Math.log(2.0) == 0.0 ? new InverseFastFourier(UtilMethods.matToComplex(modOut), false) : new InverseDiscreteFourier(modOut, false));
        idft.transform();
        this.output = idft.getComplex();
    }

    public double[][] getOutput() throws ExceptionInInitializerError {
        if (this.output == null) {
            throw new ExceptionInInitializerError("Execute hilbert_transform() function before returning result");
        }
        double[][] out = new double[this.output.length][2];
        for (int i = 0; i < out.length; ++i) {
            out[i][0] = this.output[i].getReal();
            out[i][1] = this.output[i].getImaginary();
        }
        return out;
    }

    public double[] getAmplitudeEnvelope() throws ExceptionInInitializerError {
        if (this.output == null) {
            throw new ExceptionInInitializerError("Execute hilbert_transform() function before returning result");
        }
        double[] sig = new double[this.output.length];
        for (int i = 0; i < sig.length; ++i) {
            sig[i] = this.output[i].abs();
        }
        return sig;
    }

    public double[] getInstantaneousPhase() throws ExceptionInInitializerError {
        if (this.output == null) {
            throw new ExceptionInInitializerError("Execute hilbert_transform() function before returning result");
        }
        double[] sig = new double[this.output.length];
        for (int i = 0; i < sig.length; ++i) {
            sig[i] = FastMath.atan2((double)this.output[i].getImaginary(), (double)this.output[i].getReal());
        }
        return UtilMethods.unwrap(sig);
    }

    public double[] getInstantaneousFrequency(double Fs) throws ExceptionInInitializerError {
        if (this.output == null) {
            throw new ExceptionInInitializerError("Execute hilbert_transform() function before returning result");
        }
        double[] temp = this.getInstantaneousPhase();
        double cons = Math.PI * 2;
        double[] sig = UtilMethods.diff(temp);
        for (int i = 0; i < sig.length; ++i) {
            sig[i] = sig[i] / cons * Fs;
        }
        return sig;
    }
}

