/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.transform;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.signal.ComplexDeconvolution;
import com.github.psambit9791.jdsp.signal.Deconvolution;
import com.github.psambit9791.jdsp.signal.Generate;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.stat.StatUtils;

public class InverseContinuousWavelet {
    private Complex[][] transformed;
    private int[] widths;

    public InverseContinuousWavelet(Complex[][] transformed, int[] widths) {
        if (widths.length != transformed.length) {
            throw new IllegalArgumentException("Number of widths should be same as number of wavelet transformations");
        }
        if (transformed.length == 0) {
            throw new IllegalArgumentException("transformed matrix cannot be empty.");
        }
        if (transformed.length <= 3) {
            this.transformed = transformed;
            this.widths = widths;
        } else {
            this.transformed = new Complex[][]{transformed[0], transformed[widths.length / 2], transformed[widths.length - 1]};
            this.widths = new int[]{widths[0], widths[widths.length / 2], widths[widths.length - 1]};
        }
    }

    private double[][] icwt_paul(int args) {
        double[][] out = new double[this.transformed.length][this.transformed[0].length];
        Generate gp = new Generate();
        for (int i = 0; i < out.length; ++i) {
            double norm = Math.sqrt(1.0 / (double)this.widths[i]);
            Complex[] wavelet = gp.generatePaulComplex(args, this.widths[i], this.widths[i]);
            for (int w = 0; w < wavelet.length; ++w) {
                wavelet[w] = wavelet[w].multiply(norm);
            }
            ComplexDeconvolution cdc = new ComplexDeconvolution(this.transformed[i], wavelet);
            cdc.deconvolve("same");
            out[i] = cdc.getRealOutput();
        }
        return out;
    }

    private double[][] icwt_morlet(double args) {
        double[][] out = new double[this.transformed.length][this.transformed[0].length];
        Generate gp = new Generate();
        for (int i = 0; i < out.length; ++i) {
            int N = Math.min(10 * this.widths[i], this.transformed[0].length);
            Complex[] wavelet = gp.generateMorletCWTComplex(N, args, this.widths[i]);
            wavelet = UtilMethods.reverse(wavelet);
            ComplexDeconvolution cdc = new ComplexDeconvolution(this.transformed[i], wavelet);
            cdc.deconvolve("same");
            out[i] = cdc.getRealOutput();
        }
        return out;
    }

    private double[][] icwt_ricker() {
        double[][] out = new double[this.transformed.length][this.transformed[0].length];
        Generate gp = new Generate();
        for (int i = 0; i < out.length; ++i) {
            int N = Math.min(10 * this.widths[i], this.transformed[0].length);
            double[] data = new double[this.transformed[0].length];
            for (int j = 0; j < data.length; ++j) {
                data[j] = this.transformed[i][j].getReal();
            }
            double[] wavelet = gp.generateRicker(N, this.widths[i]);
            wavelet = UtilMethods.reverse(wavelet);
            Deconvolution cdc = new Deconvolution(data, wavelet);
            out[i] = cdc.deconvolve("same");
        }
        return out;
    }

    public double[] transform(waveletType wavelet_type, double wavelet_args) throws IllegalArgumentException {
        double[][] out;
        switch (wavelet_type.ordinal()) {
            case 1: {
                out = this.icwt_ricker();
                break;
            }
            case 0: {
                out = this.icwt_morlet(wavelet_args);
                break;
            }
            case 2: {
                out = this.icwt_paul((int)wavelet_args);
                break;
            }
            default: {
                throw new ArithmeticException("wavelet_type must be RICKER, MORLET or PAUL");
            }
        }
        out = UtilMethods.transpose(out);
        double[] signal = new double[this.transformed[0].length];
        for (int i = 0; i < signal.length; ++i) {
            signal[i] = StatUtils.mean((double[])out[i]);
        }
        return signal;
    }

    public static enum waveletType {
        MORLET,
        RICKER,
        PAUL;

    }
}

