/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.transform;

import com.github.psambit9791.jdsp.transform.DiscreteCosine;
import com.github.psambit9791.jdsp.transform._InverseSineCosine;
import com.github.psambit9791.jdsp.transform._SineCosine;

public class InverseDiscreteCosine
implements _InverseSineCosine {
    private double[] signal;
    private double[] output = null;
    private _InverseSineCosine.Normalization norm;

    private int inferType(int t) {
        int inf = 0;
        if (t == 1 || t == 4) {
            inf = t;
        } else if (t == 2) {
            inf = 3;
        } else if (t == 3) {
            inf = 2;
        }
        return inf;
    }

    public InverseDiscreteCosine(double[] signal, _InverseSineCosine.Normalization norm) {
        this.signal = signal;
        this.norm = norm;
    }

    public InverseDiscreteCosine(double[] signal) {
        this.signal = signal;
        this.norm = _InverseSineCosine.Normalization.STANDARD;
    }

    @Override
    public void transform(int type) throws IllegalArgumentException {
        if (type <= 0 || type > 4) {
            throw new IllegalArgumentException("Type must be between 1 and 4");
        }
        type = this.inferType(type);
        DiscreteCosine dct = this.norm == _InverseSineCosine.Normalization.STANDARD ? new DiscreteCosine(this.signal, _SineCosine.Normalization.STANDARD) : new DiscreteCosine(this.signal, _SineCosine.Normalization.ORTHOGONAL);
        dct.transform(type);
        this.output = dct.getOutput();
    }

    @Override
    public void transform() {
        int type = this.inferType(1);
        DiscreteCosine dct = this.norm == _InverseSineCosine.Normalization.STANDARD ? new DiscreteCosine(this.signal, _SineCosine.Normalization.STANDARD) : new DiscreteCosine(this.signal, _SineCosine.Normalization.ORTHOGONAL);
        dct.transform(type);
        this.output = dct.getOutput();
    }

    @Override
    public double[] getOutput() throws ExceptionInInitializerError {
        if (this.output == null) {
            throw new ExceptionInInitializerError("Execute transform() function before returning result");
        }
        return this.output;
    }

    @Override
    public int getSignalLength() {
        return this.signal.length;
    }
}

