/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.transform;

import com.github.psambit9791.jdsp.transform._InverseFourier;
import org.apache.commons.math3.complex.Complex;

public class InverseDiscreteFourier
implements _InverseFourier {
    private double[][] complex_sequence;
    private double[] real_sequence;
    private boolean isComplex;
    private Complex[] signal = null;
    private boolean onlyPositive;

    public InverseDiscreteFourier(double[][] seq, boolean onlyPositive) {
        this.complex_sequence = seq;
        this.isComplex = true;
        this.onlyPositive = onlyPositive;
    }

    public InverseDiscreteFourier(double[] seq, boolean onlyPositive) {
        this.real_sequence = seq;
        this.isComplex = false;
        this.onlyPositive = onlyPositive;
    }

    @Override
    public void transform() {
        if (this.isComplex) {
            if (this.onlyPositive) {
                this.idftComplexMirror();
            } else {
                this.idftComplexFull();
            }
        } else if (this.onlyPositive) {
            this.idftRealMirror();
        } else {
            this.idftRealFull();
        }
    }

    @Override
    public Complex[] getComplex() throws ExceptionInInitializerError {
        this.checkOutput();
        return this.signal;
    }

    @Override
    public double[][] getComplex2D() throws ExceptionInInitializerError {
        this.checkOutput();
        double[][] ret = new double[this.signal.length][2];
        for (int i = 0; i < ret.length; ++i) {
            ret[i][0] = this.signal[i].getReal();
            ret[i][1] = this.signal[i].getImaginary();
        }
        return ret;
    }

    @Override
    public double[] getReal() throws ExceptionInInitializerError {
        this.checkOutput();
        double[] ret = new double[this.signal.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.signal[i].getReal();
        }
        return ret;
    }

    @Override
    public double[] getImaginary() throws ExceptionInInitializerError {
        this.checkOutput();
        double[] ret = new double[this.signal.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.signal[i].getImaginary();
        }
        return ret;
    }

    @Override
    public double[] getMagnitude() throws ExceptionInInitializerError {
        this.checkOutput();
        double[] ret = new double[this.signal.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.signal[i].abs();
        }
        return ret;
    }

    @Override
    public double[] getPhase() throws ExceptionInInitializerError {
        this.checkOutput();
        double[] ret = new double[this.signal.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.signal[i].getArgument();
        }
        return ret;
    }

    private void idftRealFull() {
        Complex[] out = new Complex[this.real_sequence.length];
        for (int t = 0; t < out.length; ++t) {
            double sigValR = 0.0;
            double sigValI = 0.0;
            for (int m = 0; m < out.length; ++m) {
                double angle = Math.PI * 2 * (double)t * (double)m / (double)out.length;
                sigValR += this.real_sequence[m] * Math.cos(angle);
                sigValI += this.real_sequence[m] * Math.sin(angle);
            }
            out[t] = Complex.valueOf((double)(sigValR / (double)out.length), (double)(sigValI / (double)out.length));
        }
        this.signal = out;
    }

    private void idftComplexFull() {
        Complex[] out = new Complex[this.complex_sequence.length];
        for (int t = 0; t < out.length; ++t) {
            double sigValR = 0.0;
            double sigValI = 0.0;
            for (int m = 0; m < out.length; ++m) {
                double angle = Math.PI * 2 * (double)t * (double)m / (double)out.length;
                sigValR += this.complex_sequence[m][0] * Math.cos(angle) - this.complex_sequence[m][1] * Math.sin(angle);
                sigValI += this.complex_sequence[m][0] * Math.sin(angle) + this.complex_sequence[m][1] * Math.cos(angle);
            }
            out[t] = Complex.valueOf((double)(sigValR / (double)out.length), (double)(sigValI / (double)out.length));
        }
        this.signal = out;
    }

    private void idftRealMirror() {
        int i;
        int size = (this.real_sequence.length - 1) * 2;
        Complex[] out = new Complex[size];
        double[] full_real = new double[size];
        int index = 0;
        for (i = 0; i < this.real_sequence.length; ++i) {
            full_real[index] = this.real_sequence[i];
            ++index;
        }
        for (i = this.real_sequence.length - 2; i > 0; --i) {
            full_real[index] = this.real_sequence[i];
            ++index;
        }
        for (int t = 0; t < out.length; ++t) {
            double sigValR = 0.0;
            double sigValI = 0.0;
            for (int m = 0; m < out.length; ++m) {
                double angle = Math.PI * 2 * (double)t * (double)m / (double)out.length;
                sigValR += full_real[m] * Math.cos(angle);
                sigValI += full_real[m] * Math.sin(angle);
            }
            out[t] = Complex.valueOf((double)(sigValR / (double)out.length), (double)(sigValI / (double)out.length));
        }
        this.signal = out;
    }

    private void idftComplexMirror() {
        int i;
        int size = (this.complex_sequence.length - 1) * 2;
        Complex[] out = new Complex[size];
        double[][] full_cplx = new double[size][2];
        int index = 0;
        for (i = 0; i < this.complex_sequence.length; ++i) {
            full_cplx[index][0] = this.complex_sequence[i][0];
            full_cplx[index][1] = this.complex_sequence[i][1];
            ++index;
        }
        for (i = this.complex_sequence.length - 2; i > 0; --i) {
            full_cplx[index][0] = this.complex_sequence[i][0];
            full_cplx[index][1] = -this.complex_sequence[i][1];
            ++index;
        }
        for (int t = 0; t < out.length; ++t) {
            double sigValR = 0.0;
            double sigValI = 0.0;
            for (int m = 0; m < out.length; ++m) {
                double angle = Math.PI * 2 * (double)t * (double)m / (double)out.length;
                sigValR += full_cplx[m][0] * Math.cos(angle) - full_cplx[m][1] * Math.sin(angle);
                sigValI += full_cplx[m][0] * Math.sin(angle) + full_cplx[m][1] * Math.cos(angle);
            }
            out[t] = Complex.valueOf((double)(sigValR / (double)out.length), (double)(sigValI / (double)out.length));
        }
        this.signal = out;
    }

    private void checkOutput() {
        if (this.signal == null) {
            throw new ExceptionInInitializerError("Execute transform() function before returning result");
        }
    }
}

