/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.transform;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.transform._InverseFourier;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.TransformType;

public class InverseFastFourier
implements _InverseFourier {
    private Complex[] sequence;
    private Complex[] signal = null;
    private FastFourierTransformer ft;

    private void checkOutput() {
        if (this.signal == null) {
            throw new ExceptionInInitializerError("Execute transform() function before returning result");
        }
    }

    private Complex[] toFullSequence(Complex[] signal) {
        int size = (signal.length - 1) * 2;
        Complex[] out = new Complex[size];
        System.arraycopy(signal, 0, out, 0, signal.length);
        int index = signal.length;
        for (int i = signal.length - 2; i > 0; --i) {
            out[index] = signal[i].conjugate();
            ++index;
        }
        return out;
    }

    public InverseFastFourier(double[][] fftOutput, boolean onlyPositive) {
        Complex[] temp = UtilMethods.matToComplex(fftOutput);
        this.sequence = onlyPositive ? this.toFullSequence(temp) : temp;
        this.ft = new FastFourierTransformer(DftNormalization.STANDARD);
    }

    public InverseFastFourier(Complex[] fftOutput, boolean onlyPositive) {
        this.sequence = onlyPositive ? this.toFullSequence(fftOutput) : fftOutput;
        this.ft = new FastFourierTransformer(DftNormalization.STANDARD);
    }

    public InverseFastFourier(Complex[] fftOutput, boolean onlyPositive, DftNormalization norm) {
        this.sequence = onlyPositive ? this.toFullSequence(fftOutput) : fftOutput;
        this.ft = new FastFourierTransformer(norm);
    }

    @Override
    public void transform() {
        this.signal = this.ft.transform(this.sequence, TransformType.INVERSE);
    }

    @Override
    public Complex[] getComplex() throws ExceptionInInitializerError {
        this.checkOutput();
        return this.signal;
    }

    @Override
    public double[][] getComplex2D() throws ExceptionInInitializerError {
        this.checkOutput();
        double[][] ret = new double[this.signal.length][2];
        for (int i = 0; i < ret.length; ++i) {
            ret[i][0] = this.signal[i].getReal();
            ret[i][1] = this.signal[i].getImaginary();
        }
        return ret;
    }

    @Override
    public double[] getReal() throws ExceptionInInitializerError {
        this.checkOutput();
        double[] real = new double[this.signal.length];
        for (int i = 0; i < real.length; ++i) {
            real[i] = this.signal[i].getReal();
        }
        return real;
    }

    @Override
    public double[] getImaginary() throws ExceptionInInitializerError {
        this.checkOutput();
        double[] imag = new double[this.signal.length];
        for (int i = 0; i < imag.length; ++i) {
            imag[i] = this.signal[i].getImaginary();
        }
        return imag;
    }

    @Override
    public double[] getMagnitude() throws ExceptionInInitializerError {
        this.checkOutput();
        double[] ret = new double[this.signal.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.signal[i].abs();
        }
        return ret;
    }

    @Override
    public double[] getPhase() throws ExceptionInInitializerError {
        this.checkOutput();
        double[] ret = new double[this.signal.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.signal[i].getArgument();
        }
        return ret;
    }
}

