/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.windows;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.windows._Window;
import java.util.Arrays;

public class GeneralCosine
extends _Window {
    private double[] window;
    private final double[] weights;
    private final boolean sym;
    private final int len;

    public GeneralCosine(int len, double[] weights, boolean sym) throws IllegalArgumentException {
        super(len);
        this.len = len;
        this.weights = weights;
        this.sym = sym;
        this.generateWindow();
    }

    public GeneralCosine(int len, double[] weights) throws IllegalArgumentException {
        this(len, weights, true);
    }

    private void generateWindow() {
        int tempLen = super.extend(this.len, this.sym);
        double[] tempArr = UtilMethods.linspace(-Math.PI, Math.PI, tempLen, true);
        this.window = new double[tempLen];
        Arrays.fill(this.window, 0.0);
        for (int i = 0; i < this.weights.length; ++i) {
            for (int j = 0; j < tempArr.length; ++j) {
                this.window[j] = this.window[j] + this.weights[i] * Math.cos((double)i * tempArr[j]);
            }
        }
        this.window = super.truncate(this.window);
    }

    @Override
    public double[] getWindow() {
        return this.window;
    }
}

