/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.windows;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.windows._Window;
import java.util.Arrays;

public class Tukey
extends _Window {
    private double[] window;
    private final double alpha;
    private final boolean sym;
    private final int len;

    public Tukey(int len, double alpha, boolean sym) throws IllegalArgumentException {
        super(len);
        this.len = len;
        this.alpha = alpha;
        this.sym = sym;
        if (alpha > 1.0 || alpha < 0.0) {
            throw new IllegalArgumentException("Alpha must be between 0 and 1");
        }
        this.generateWindow();
    }

    public Tukey(int len, double alpha) throws IllegalArgumentException {
        this(len, alpha, true);
    }

    private void generateWindow() {
        int i;
        int tempLen = super.extend(this.len, this.sym);
        this.window = new double[tempLen];
        double[] n = UtilMethods.arange(0.0, (double)tempLen, 1.0);
        int width = (int)Math.floor(this.alpha * (double)(tempLen - 1) / 2.0);
        double[] n1 = UtilMethods.splitByIndex(n, 0, width + 1);
        double[] n2 = UtilMethods.splitByIndex(n, width + 1, tempLen - width - 1);
        double[] n3 = UtilMethods.splitByIndex(n, tempLen - width - 1, tempLen);
        for (i = 0; i < n1.length; ++i) {
            n1[i] = 0.5 * (1.0 + Math.cos(Math.PI * (-1.0 + 2.0 * n1[i] / this.alpha / (double)(tempLen - 1))));
        }
        Arrays.fill(n2, 1.0);
        for (i = 0; i < n3.length; ++i) {
            n3[i] = 0.5 * (1.0 + Math.cos(Math.PI * (-2.0 / this.alpha + 1.0 + 2.0 * n3[i] / this.alpha / (double)(tempLen - 1))));
        }
        this.window = UtilMethods.concatenateArray(n1, n2);
        this.window = UtilMethods.concatenateArray(this.window, n3);
        this.window = super.truncate(this.window);
    }

    @Override
    public double[] getWindow() {
        return this.window;
    }
}

