/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans.accessors;

import oracle.ucp.jdbc.JDBCConnectionPoolStatistics;
import oracle.ucp.jdbc.PoolDataSource;
import psiprobe.beans.accessors.DatasourceAccessor;
import psiprobe.model.DataSourceInfo;

public class OracleUcpDatasourceAccessor
implements DatasourceAccessor {
    @Override
    public DataSourceInfo getInfo(Object resource) throws Exception {
        DataSourceInfo dataSourceInfo = null;
        if (this.canMap(resource)) {
            PoolDataSource source = (PoolDataSource)resource;
            JDBCConnectionPoolStatistics stats = source.getStatistics();
            dataSourceInfo = new DataSourceInfo();
            if (stats != null) {
                dataSourceInfo.setBusyConnections(stats.getBorrowedConnectionsCount());
                dataSourceInfo.setEstablishedConnections(stats.getTotalConnectionsCount());
            } else {
                dataSourceInfo.setBusyConnections(0);
                dataSourceInfo.setEstablishedConnections(0);
            }
            dataSourceInfo.setMaxConnections(source.getMaxPoolSize());
            dataSourceInfo.setJdbcUrl(source.getURL());
            dataSourceInfo.setUsername(source.getUser());
            dataSourceInfo.setResettable(false);
            dataSourceInfo.setType("oracle-ucp");
        }
        return dataSourceInfo;
    }

    @Override
    public boolean reset(Object resource) throws Exception {
        return false;
    }

    @Override
    public boolean canMap(Object resource) {
        return ("oracle.ucp.jdbc.PoolDataSourceImpl".equals(resource.getClass().getName()) || "oracle.ucp.jdbc.PoolXADataSourceImpl".equals(resource.getClass().getName())) && resource instanceof PoolDataSource;
    }
}

