/*
 * Decompiled with CFR 0.152.
 */
package psiprobe;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.Valve;
import org.apache.catalina.WebResource;
import org.apache.catalina.deploy.NamingResourcesImpl;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.naming.ContextAccessController;
import org.apache.tomcat.util.descriptor.web.ApplicationParameter;
import org.apache.tomcat.util.descriptor.web.ContextResource;
import org.apache.tomcat.util.descriptor.web.ContextResourceLink;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import psiprobe.AbstractTomcatContainer;
import psiprobe.Tomcat85AgentValve;
import psiprobe.model.ApplicationParam;
import psiprobe.model.ApplicationResource;
import psiprobe.model.FilterInfo;
import psiprobe.model.FilterMapping;

public class Tomcat85ContainerAdapter
extends AbstractTomcatContainer {
    protected Valve createValve() {
        return new Tomcat85AgentValve();
    }

    public boolean canBoundTo(String binding) {
        if (binding == null) {
            return false;
        }
        return binding.startsWith("Apache Tomcat/8.5") || binding.startsWith("Apache Tomcat (TomEE)/8.5") || binding.startsWith("Pivotal tc") && binding.contains("/8.5");
    }

    protected List<FilterMapping> getFilterMappings(FilterMap fmap, String dm, String filterClass) {
        String[] urls = fmap.getURLPatterns();
        String[] servlets = fmap.getServletNames();
        ArrayList<FilterMapping> results = new ArrayList<FilterMapping>(urls.length + servlets.length);
        this.addFilterMapping(fmap.getFilterName(), dm, filterClass, urls, results, AbstractTomcatContainer.FilterMapType.URL);
        this.addFilterMapping(fmap.getFilterName(), dm, filterClass, servlets, results, AbstractTomcatContainer.FilterMapType.SERVLET_NAME);
        return results;
    }

    protected JspCompilationContext createJspCompilationContext(String name, Options opt, ServletContext sctx, JspRuntimeContext jrctx, ClassLoader classLoader) {
        JspCompilationContext jcctx = new JspCompilationContext(name, opt, sctx, null, jrctx);
        jcctx.setClassLoader(classLoader);
        return jcctx;
    }

    public void addContextResourceLink(Context context, List<ApplicationResource> resourceList, boolean contextBound) {
        NamingResourcesImpl namingResources = context.getNamingResources();
        for (ContextResourceLink link : namingResources.findResourceLinks()) {
            ApplicationResource resource = new ApplicationResource();
            this.logger.debug("reading resourceLink: {}", (Object)link.getName());
            resource.setApplicationName(context.getName());
            resource.setName(link.getName());
            resource.setType(link.getType());
            resource.setLinkTo(link.getGlobal());
            resourceList.add(resource);
        }
    }

    public void addContextResource(Context context, List<ApplicationResource> resourceList, boolean contextBound) {
        NamingResourcesImpl namingResources = context.getNamingResources();
        for (ContextResource contextResource : namingResources.findResources()) {
            ApplicationResource resource = new ApplicationResource();
            this.logger.info("reading resource: {}", (Object)contextResource.getName());
            resource.setApplicationName(context.getName());
            resource.setName(contextResource.getName());
            resource.setType(contextResource.getType());
            resource.setScope(contextResource.getScope());
            resource.setAuth(contextResource.getAuth());
            resource.setDescription(contextResource.getDescription());
            resourceList.add(resource);
        }
    }

    public List<FilterMapping> getApplicationFilterMaps(Context context) {
        FilterMap[] fms = context.findFilterMaps();
        ArrayList<FilterMapping> filterMaps = new ArrayList<FilterMapping>(fms.length);
        for (FilterMap filterMap : fms) {
            String dm;
            if (filterMap == null) continue;
            switch (filterMap.getDispatcherMapping()) {
                case 16: {
                    dm = "ASYNC";
                    break;
                }
                case 1: {
                    dm = "ERROR";
                    break;
                }
                case 2: {
                    dm = "FORWARD";
                    break;
                }
                case 4: {
                    dm = "INCLUDE";
                    break;
                }
                case 8: {
                    dm = "REQUEST";
                    break;
                }
                default: {
                    dm = "";
                }
            }
            String filterClass = "";
            FilterDef fd = context.findFilterDef(filterMap.getFilterName());
            if (fd != null) {
                filterClass = fd.getFilterClass();
            }
            List<FilterMapping> filterMappings = this.getFilterMappings(filterMap, dm, filterClass);
            filterMaps.addAll(filterMappings);
        }
        return filterMaps;
    }

    public List<FilterInfo> getApplicationFilters(Context context) {
        FilterDef[] fds = context.findFilterDefs();
        ArrayList<FilterInfo> filterDefs = new ArrayList<FilterInfo>(fds.length);
        for (FilterDef filterDef : fds) {
            if (filterDef == null) continue;
            FilterInfo fi = Tomcat85ContainerAdapter.getFilterInfo(filterDef);
            filterDefs.add(fi);
        }
        return filterDefs;
    }

    private static FilterInfo getFilterInfo(FilterDef fd) {
        FilterInfo fi = new FilterInfo();
        fi.setFilterName(fd.getFilterName());
        fi.setFilterClass(fd.getFilterClass());
        fi.setFilterDesc(fd.getDescription());
        return fi;
    }

    public List<ApplicationParam> getApplicationInitParams(Context context) {
        HashSet<String> nonOverridableParams = new HashSet<String>();
        for (ApplicationParameter appParam : context.findApplicationParameters()) {
            if (appParam == null || appParam.getOverride()) continue;
            nonOverridableParams.add(appParam.getName());
        }
        ArrayList<ApplicationParam> initParams = new ArrayList<ApplicationParam>(20);
        ServletContext servletCtx = context.getServletContext();
        for (String paramName : Collections.list(servletCtx.getInitParameterNames())) {
            ApplicationParam param = new ApplicationParam();
            param.setName(paramName);
            param.setValue((Object)servletCtx.getInitParameter(paramName));
            param.setFromDeplDescr(context.findParameter(paramName) != null && !nonOverridableParams.contains(paramName));
            initParams.add(param);
        }
        return initParams;
    }

    public boolean resourceExists(String name, Context context) {
        return context.getResources().getResource(name) != null;
    }

    public InputStream getResourceStream(String name, Context context) throws IOException {
        WebResource resource = context.getResources().getResource(name);
        return resource.getInputStream();
    }

    public Long[] getResourceAttributes(String name, Context context) {
        Long[] result = new Long[2];
        WebResource resource = context.getResources().getResource(name);
        result[0] = resource.getContentLength();
        result[1] = resource.getLastModified();
        return result;
    }

    protected Object getNamingToken(Context context) {
        Object token = context.getNamingToken();
        if (!ContextAccessController.checkSecurityToken((Object)context, (Object)token)) {
            this.logger.error("Couldn't get a valid security token. ClassLoader binding will fail.");
        }
        return token;
    }
}

