/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Arrays;
import weka.core.OptionHandler;
import weka.core.Utils;

public class UtilsPT {
    public static double median(double[] array) {
        double[] tmpArray = Arrays.copyOf(array, array.length);
        Arrays.sort(tmpArray);
        double median = 0.0;
        int centerIdx = tmpArray.length / 2;
        median = tmpArray.length % 2 == 1 ? tmpArray[centerIdx] : (tmpArray[centerIdx] + tmpArray[centerIdx - 1]) / 2.0;
        return median;
    }

    public static double quantile(double[] array, double q) {
        double[] tmpArray = Arrays.copyOf(array, array.length);
        Arrays.sort(tmpArray);
        if (q > 1.0) {
            return tmpArray[array.length - 1];
        }
        if (q < 0.0) {
            return tmpArray[0];
        }
        double preIdx = q * (double)array.length;
        double idx = Math.ceil(preIdx);
        double quantile = 0.0;
        quantile = Utils.eq((double)preIdx, (double)idx) ? 0.5 * (tmpArray[(int)idx - 1] + tmpArray[(int)idx]) : tmpArray[(int)idx - 1];
        return quantile;
    }

    public static double truncatedMean(double[] array) {
        if (array.length < 3) {
            return Utils.mean((double[])array);
        }
        double minVal = Double.POSITIVE_INFINITY;
        double maxVal = Double.NEGATIVE_INFINITY;
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            sum += array[i];
            if (array[i] < minVal) {
                minVal = array[i];
            }
            if (!(array[i] > maxVal)) continue;
            maxVal = array[i];
        }
        double mean = (sum -= minVal + maxVal) / (double)(array.length - 2);
        return mean;
    }

    public static double var(double[] array) {
        double variance = 0.0;
        if (array.length == 1) {
            return 0.0;
        }
        double mean = Utils.mean((double[])array);
        for (int i = 0; i < array.length; ++i) {
            variance += (array[i] - mean) * (array[i] - mean);
        }
        return variance /= (double)(array.length - 1);
    }

    public static double stdDev(double[] array) {
        return Math.sqrt(UtilsPT.var(array));
    }

    public static double cov(double[] arr1, double[] arr2) throws Exception {
        if (arr1.length != arr2.length) {
            throw new Exception("Incompatible arrays");
        }
        if (arr1.length == 1) {
            return 0.0;
        }
        double cov = 0.0;
        double m1 = Utils.mean((double[])arr1);
        double m2 = Utils.mean((double[])arr2);
        for (int i = 0; i < arr1.length; ++i) {
            cov += (arr1[i] - m1) * (arr2[i] - m2);
        }
        return cov /= (double)(arr1.length - 1);
    }

    public static double corr(double[] arr1, double[] arr2) throws Exception {
        double corr = UtilsPT.cov(arr1, arr2);
        if (arr1.length == 1) {
            return 1.0;
        }
        return corr /= UtilsPT.stdDev(arr1) * UtilsPT.stdDev(arr2);
    }

    public static boolean compareDoubleArrays(double[] arr1, double[] arr2) {
        if (arr1 == arr2) {
            return true;
        }
        if (arr1 == null || arr2 == null) {
            return false;
        }
        if (arr1.length != arr2.length) {
            return false;
        }
        int len = arr1.length;
        for (int i = 0; i < len; ++i) {
            if (Double.doubleToLongBits(arr1[i]) == Double.doubleToLongBits(arr2[i]) || Utils.eq((double)arr1[i], (double)arr2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean compareFloatArrays(float[] arr1, float[] arr2) {
        if (arr1 == arr2) {
            return true;
        }
        if (arr1 == null || arr2 == null) {
            return false;
        }
        if (arr1.length != arr2.length) {
            return false;
        }
        int len = arr1.length;
        for (int i = 0; i < len; ++i) {
            if (Float.floatToIntBits(arr1[i]) == Float.floatToIntBits(arr2[i]) || (double)Math.abs(arr1[i] - arr2[i]) < Utils.SMALL) continue;
            return false;
        }
        return true;
    }

    public static String getClassAndOptions(Object obj) {
        String className = obj.getClass().getName();
        String objOptions = " ";
        if (obj instanceof OptionHandler) {
            objOptions = Utils.joinOptions((String[])((OptionHandler)obj).getOptions());
        }
        String result = "" + className + " " + objOptions;
        return result;
    }

    public static int parseIntegerOption(String[] options, String optionFlag, int defValue) {
        int value = defValue;
        try {
            String optionStr = Utils.getOption((String)optionFlag, (String[])options);
            value = Integer.parseInt(optionStr);
        }
        catch (Exception e) {
            System.err.println("Invalid option" + optionFlag + "\n Default value will be used");
        }
        return value;
    }

    public static double parseDoubleOption(String[] options, String optionFlag, double defValue) {
        double value = defValue;
        try {
            String optionStr = Utils.getOption((String)optionFlag, (String[])options);
            value = Double.parseDouble(optionStr);
        }
        catch (Exception e) {
            System.err.println("Invalid option: " + optionFlag + "\n Default value will be used");
            System.err.println("Options: " + Arrays.toString(options));
            System.err.println("Default value: " + defValue);
        }
        return value;
    }

    public static Object parseObjectOptions(String[] options, String optionFlag, Object defValue, Class<?> classtype) throws Exception {
        Object parsedObj = defValue;
        try {
            String[] objectClassSpec;
            String objectOptionString = Utils.getOption((String)optionFlag, (String[])options);
            if (objectOptionString.length() != 0) {
                objectClassSpec = Utils.splitOptions((String)objectOptionString);
                if (objectClassSpec.length == 0) {
                    throw new Exception("Invalid prototype specification string.");
                }
            } else {
                throw new Exception("No option");
            }
            String className = objectClassSpec[0];
            objectClassSpec[0] = "";
            parsedObj = Utils.forName(classtype, (String)className, (String[])objectClassSpec);
        }
        catch (Exception e) {
            System.err.println("Option " + optionFlag + " cannot be parsed. Default value is used");
            System.err.println("Default value: " + defValue.toString());
            System.err.println("Class type: " + classtype.toGenericString());
            System.err.println("Options String: " + Arrays.toString(options));
        }
        return parsedObj;
    }

    public static double[] softMax(double[] array) {
        double[] tmp = Arrays.copyOf(array, array.length);
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            tmp[i] = Math.exp(tmp[i]);
            sum += tmp[i];
        }
        if (!Utils.eq((double)0.0, (double)sum)) {
            Utils.normalize((double[])tmp);
        }
        return tmp;
    }

    public static double[] softMin(double[] array) {
        double[] tmp = Arrays.copyOf(array, array.length);
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            tmp[i] = Math.exp(-tmp[i]);
            sum += tmp[i];
        }
        if (!Utils.eq((double)0.0, (double)sum)) {
            Utils.normalize((double[])tmp);
        }
        return tmp;
    }
}

