/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators.density;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.UtilsPT;
import weka.estimators.density.Kernel;
import weka.estimators.density.KernelDensityEstimator;
import weka.estimators.density.kernels.EpanechnikovKernel;
import weka.estimators.density.kernels.GaussianKernel;
import weka.tools.WeightedValuesHolder;

public abstract class AbstractKernelEstimator
implements KernelDensityEstimator,
Serializable,
OptionHandler {
    private static final long serialVersionUID = 7610749246727072220L;
    protected double bandwidth = 0.1;
    protected Kernel kernel = new GaussianKernel();
    protected WeightedValuesHolder valHolder = new WeightedValuesHolder();
    protected double weightSum = 0.0;

    @Override
    public void addValues(double[] data, double[] weight) {
        this.valHolder.addValues(data, weight);
    }

    public void addValue(double data, double weight) {
        this.valHolder.addValue(data, weight);
    }

    public String kernelTipText() {
        return "Kernel used with the kernel estimator";
    }

    @Override
    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    @Override
    public Kernel getKernel() {
        return this.kernel;
    }

    public String bandwidthTipText() {
        return "Bandwidth (smoothing) paremeter for the kernel estimator";
    }

    @Override
    public void setBandwidth(double bandwidth) {
        this.bandwidth = bandwidth;
    }

    @Override
    public double getBandwidth() {
        return this.bandwidth;
    }

    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tBandwidth to use (default: 1).\n", "BW", 1, "-BW"));
        newVector.addElement(new Option("\tKernel object to use (default: weka.estimators.density.kernels.EpanechnikovKernel).\n", "KE", 1, "-KE"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.setKernel((Kernel)UtilsPT.parseObjectOptions(options, "KE", new EpanechnikovKernel(), Kernel.class));
        this.setBandwidth(UtilsPT.parseDoubleOption(options, "BW", 0.1));
    }

    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-BW");
        options.add("" + this.bandwidth);
        options.add("-KE");
        options.add(UtilsPT.getClassAndOptions(this.kernel));
        return options.toArray(new String[0]);
    }

    public String toString() {
        StringBuilder strBuild = new StringBuilder();
        strBuild.append("Kernel Estimator \n");
        strBuild.append("Kernel: " + this.kernel.toString() + "\n");
        strBuild.append("Number of samples: " + this.valHolder.getNumVals() + "\n");
        strBuild.append("Bandwidth: " + this.bandwidth + "\n");
        return strBuild.toString();
    }
}

