/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators.density;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.UtilsPT;
import weka.estimators.density.DensityEstimator;
import weka.estimators.density.KernelDensityEstimator;
import weka.estimators.density.SimpleKernelEstimator;

public abstract class BandwidthSelectionKernelEstimator
implements DensityEstimator,
Serializable,
OptionHandler {
    private static final long serialVersionUID = 5735185710445258136L;
    protected KernelDensityEstimator kernEstim = new SimpleKernelEstimator();
    protected boolean isModified = true;

    @Override
    public double getPDF(double x) {
        this.setBandwidthInternal();
        return this.kernEstim.getPDF(x);
    }

    @Override
    public double getCDF(double x) {
        this.setBandwidthInternal();
        return this.kernEstim.getCDF(x);
    }

    @Override
    public void addValues(double[] data, double[] weight) {
        this.kernEstim.addValues(data, weight);
        this.isModified = true;
    }

    @Override
    public double[] getValues() {
        return this.kernEstim.getValues();
    }

    @Override
    public double[] getWeights() {
        return this.kernEstim.getWeights();
    }

    public void addValue(double data, double weight) {
        this.kernEstim.addValue(data, weight);
        this.isModified = true;
    }

    protected abstract void findBandwidth();

    private void setBandwidthInternal() {
        if (!this.isModified) {
            return;
        }
        this.findBandwidth();
        this.isModified = false;
    }

    public KernelDensityEstimator getKernEstim() {
        return this.kernEstim;
    }

    public void setKernEstim(KernelDensityEstimator kernEstim) {
        this.kernEstim = kernEstim;
        this.isModified = true;
    }

    public String kernEstimTipText() {
        return "Kernel estimator to use";
    }

    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tKernel object to use (default: weka.estimators.density.SimpleKernelEstimator).\n", "KES", 1, "-KES"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.setKernEstim((KernelDensityEstimator)UtilsPT.parseObjectOptions(options, "KES", new SimpleKernelEstimator(), KernelDensityEstimator.class));
    }

    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-KES");
        options.add(UtilsPT.getClassAndOptions(this.kernEstim));
        return options.toArray(new String[0]);
    }

    public String toString() {
        return "Bandwidth Selection Kernel Estimator:\n" + this.kernEstim.toString();
    }
}

