/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators.density;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.UtilsPT;
import weka.estimators.density.DensityEstimator;
import weka.estimators.density.SimpleKernelEstimator;

public class BoundedEstimator
implements DensityEstimator,
Serializable,
OptionHandler {
    private static final long serialVersionUID = 7156208703546768815L;
    protected DensityEstimator kernEstim = new SimpleKernelEstimator();
    protected double lowerBound = 0.0;
    protected double upperBound = 1.0;

    public void addValue(double data, double weight) {
        this.kernEstim.addValue(data, weight);
    }

    @Override
    public double getPDF(double x) {
        if (x < this.lowerBound) {
            return 0.0;
        }
        if (x > this.upperBound) {
            return 0.0;
        }
        return this.kernEstim.getPDF(x) + this.kernEstim.getPDF(2.0 * this.lowerBound - x) + this.kernEstim.getPDF(2.0 * this.upperBound - x);
    }

    @Override
    public double getCDF(double x) {
        if (x < this.lowerBound) {
            return 0.0;
        }
        if (x > this.upperBound) {
            return 1.0;
        }
        return this.kernEstim.getCDF(x) - this.kernEstim.getCDF(2.0 * this.lowerBound - x) + this.kernEstim.getCDF(2.0 * this.upperBound - this.lowerBound) - this.kernEstim.getCDF(2.0 * this.upperBound - x);
    }

    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tEstimator object to use (default: weka.estimators.density.SimpleKernelEstimator).\n", "KES", 1, "-KES"));
        newVector.addElement(new Option("\tLower Bound to use (default: 1).\n", "LB", 1, "-LB"));
        newVector.addElement(new Option("\tUpper Bound to use (default: 1).\n", "UB", 1, "-UB"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.setKernEstim((DensityEstimator)UtilsPT.parseObjectOptions(options, "KES", new SimpleKernelEstimator(), DensityEstimator.class));
        this.setLowerBound(UtilsPT.parseDoubleOption(options, "LB", 0.0));
        this.setUpperBound(UtilsPT.parseDoubleOption(options, "UB", 1.0));
    }

    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-KES");
        options.add(UtilsPT.getClassAndOptions(this.getKernEstim()));
        options.add("-LB");
        options.add("" + this.getLowerBound());
        options.add("-UB");
        options.add("" + this.getUpperBound());
        return options.toArray(new String[0]);
    }

    public String kernEstimTipText() {
        return "The kernel estimator used inside the bounded estimator";
    }

    public DensityEstimator getKernEstim() {
        return this.kernEstim;
    }

    public void setKernEstim(DensityEstimator densityEstimator) {
        this.kernEstim = densityEstimator;
    }

    public String lowerBoundTipText() {
        return "Lower bound of the distribution.";
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double lowerBound) {
        this.lowerBound = lowerBound;
    }

    public String upperBoundTipText() {
        return "Upper bound of the distribution.";
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double upperBound) {
        this.upperBound = upperBound;
    }

    @Override
    public void addValues(double[] data, double[] weight) {
        this.kernEstim.addValues(data, weight);
    }

    public String toString() {
        StringBuilder strBuild = new StringBuilder();
        strBuild.append("Bounded Estimator \n");
        strBuild.append("Lower Bound: " + this.getLowerBound() + "\n");
        strBuild.append("Upper Bound: " + this.getUpperBound() + "\n");
        strBuild.append(this.kernEstim.toString() + "\n");
        return strBuild.toString();
    }

    @Override
    public double[] getValues() {
        return this.kernEstim.getValues();
    }

    @Override
    public double[] getWeights() {
        return this.kernEstim.getWeights();
    }
}

