/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators.density;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.UtilsPT;
import weka.estimators.density.DensityEstimator;
import weka.estimators.density.SimpleKernelEstimator;

public class CachedEstimator
implements DensityEstimator,
Serializable,
OptionHandler {
    private static final long serialVersionUID = -5064176625064529202L;
    protected DensityEstimator densEstim = new SimpleKernelEstimator();
    protected HashMap<Double, Double> pdfHash = new HashMap();
    protected HashMap<Double, Double> cdfHash = new HashMap();

    public void addValue(double data, double weight) {
        this.densEstim.addValue(data, weight);
        this.pdfHash.clear();
        this.cdfHash.clear();
    }

    @Override
    public double getPDF(double x) {
        Double pdfO = this.pdfHash.get(x);
        double pdf = 0.0;
        if (pdfO == null) {
            pdf = this.densEstim.getPDF(x);
            this.pdfHash.put(x, pdf);
            return pdf;
        }
        return pdfO;
    }

    @Override
    public double getCDF(double x) {
        Double cdfO = this.cdfHash.get(x);
        double cdf = 0.0;
        if (cdfO == null) {
            cdf = this.densEstim.getCDF(x);
            this.cdfHash.put(x, cdf);
            return cdf;
        }
        return cdfO;
    }

    @Override
    public void addValues(double[] data, double[] weight) {
        this.densEstim.addValues(data, weight);
        this.pdfHash.clear();
        this.cdfHash.clear();
    }

    @Override
    public double[] getValues() {
        return this.densEstim.getValues();
    }

    @Override
    public double[] getWeights() {
        return this.densEstim.getWeights();
    }

    public DensityEstimator getDensEstim() {
        return this.densEstim;
    }

    public void setDensEstim(DensityEstimator densEstim) {
        this.densEstim = densEstim;
    }

    public String densEstimTipText() {
        return "Returns the density estimator used.";
    }

    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tDensity Estimator to use (default: weka.estimators.density.SimpleKernelEstimator).\n", "EST", 1, "-EST"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.setDensEstim((DensityEstimator)UtilsPT.parseObjectOptions(options, "EST", new SimpleKernelEstimator(), DensityEstimator.class));
    }

    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-EST");
        options.add(UtilsPT.getClassAndOptions(this.densEstim));
        return options.toArray(new String[0]);
    }
}

