/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators.density.bandwidthFinders;

import weka.core.UtilsPT;
import weka.estimators.density.Kernel;
import weka.estimators.density.bandwidthFinders.SimpleBandwidthFinder;
import weka.tools.numericIntegration.Function;
import weka.tools.numericIntegration.SimpsonsIntegrator;

public class MaximalSmoothingPrincipleBandwidthSelectionKernel
extends SimpleBandwidthFinder {
    private static final long serialVersionUID = 2498101140294446576L;

    @Override
    protected void findBandwidth() {
        double[] sample = this.kernEstim.getValues();
        double sampleSD = UtilsPT.stdDev(sample);
        int sampleSize = sample.length;
        double kernelSD = 1.0;
        double kernelSQ = 1.0 / (2.0 * Math.sqrt(Math.PI));
        try {
            kernelSD = this.findKernelSecondMoment();
            kernelSQ = this.findKernelSquareIntegral();
        }
        catch (Exception e) {
            e.printStackTrace();
            kernelSD = 1.0;
            kernelSQ = 1.0 / (2.0 * Math.sqrt(Math.PI));
        }
        double h = this.scaleFactor * 3.0 * Math.pow(35 * sampleSize, -0.2) * sampleSD * Math.pow(kernelSD, -0.8) * Math.pow(kernelSQ, 0.2);
        if (h < this.minH) {
            h = this.minH;
        }
        this.kernEstim.setBandwidth(h);
    }

    private double findKernelSecondMoment() throws Exception {
        Function fun = new Function(){

            public double value(double argument) {
                Kernel kern = MaximalSmoothingPrincipleBandwidthSelectionKernel.this.kernEstim.getKernel();
                return argument * argument * kern.getKernelPDFValue(argument);
            }
        };
        SimpsonsIntegrator integr = new SimpsonsIntegrator();
        integr.setFunction(fun);
        Kernel kern = this.kernEstim.getKernel();
        integr.setLowerBound(kern.supportLower());
        integr.setUpperBound(kern.supportUpper());
        return integr.integrate();
    }

    private double findKernelSquareIntegral() throws Exception {
        Function fun = new Function(){

            public double value(double argument) {
                Kernel kern = MaximalSmoothingPrincipleBandwidthSelectionKernel.this.kernEstim.getKernel();
                double val = kern.getKernelPDFValue(argument);
                return val * val;
            }
        };
        SimpsonsIntegrator integr = new SimpsonsIntegrator();
        integr.setFunction(fun);
        Kernel kern = this.kernEstim.getKernel();
        integr.setLowerBound(kern.supportLower());
        integr.setUpperBound(kern.supportUpper());
        return integr.integrate();
    }
}

