/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators.density.bandwidthFinders;

import weka.core.UtilsPT;
import weka.estimators.density.bandwidthFinders.SimpleBandwidthFinder;

public class SilvermanBandwidthSelectionKernel
extends SimpleBandwidthFinder {
    private static final long serialVersionUID = -6985984437409051201L;

    @Override
    protected void findBandwidth() {
        double[] vals = this.getValues();
        double sd = UtilsPT.stdDev(vals);
        double iqr = UtilsPT.quantile(vals, 0.75) - UtilsPT.quantile(vals, 0.25) / 1.34;
        double h = this.scaleFactor * 0.9 * Math.min(sd, iqr) * Math.pow(vals.length, 0.0);
        h = Math.max(h, this.minH);
        this.kernEstim.setBandwidth(h);
    }

    @Override
    public String toString() {
        return "Kernel estimator with kernel bandwidth found using Silverman's rule:\n" + this.kernEstim.toString();
    }
}

