/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators.density.kernels;

import java.io.Serializable;
import weka.estimators.density.Kernel;

public class CosineKernel
implements Kernel,
Serializable {
    private static final long serialVersionUID = -6943481377417404445L;

    @Override
    public double getKernelPDFValue(double x) {
        if (x > -1.0 & x < 1.0) {
            return 0.7853981633974483 * Math.cos(1.5707963267948966 * x);
        }
        return 0.0;
    }

    @Override
    public double getKernelCDFValue(double x) {
        if (x <= -1.0) {
            return 0.0;
        }
        if (x > -1.0 & x <= 1.0) {
            return 0.5 + 0.5 * Math.sin(1.5707963267948966 * x);
        }
        return 1.0;
    }

    public String toString() {
        return "Cosine Kernel";
    }

    @Override
    public double supportLower() {
        return -1.0;
    }

    @Override
    public double supportUpper() {
        return 1.0;
    }
}

