/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators.density.kernels;

import java.io.Serializable;
import weka.estimators.density.Kernel;

public class EpanechnikovKernel
implements Kernel,
Serializable {
    private static final long serialVersionUID = -3522344228132893688L;

    @Override
    public double getKernelPDFValue(double x) {
        if (x > -1.0 & x < 1.0) {
            return 0.75 * (1.0 - x * x);
        }
        return 0.0;
    }

    @Override
    public double getKernelCDFValue(double x) {
        if (x <= -1.0) {
            return 0.0;
        }
        if (x > -1.0 & x <= 1.0) {
            return -0.25 * x * x * x + 0.75 * x + 0.5;
        }
        return 1.0;
    }

    public String toString() {
        return "Epanechnikov Kernel";
    }

    @Override
    public double supportLower() {
        return -1.0;
    }

    @Override
    public double supportUpper() {
        return 1.0;
    }
}

