/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators.density.kernels;

import java.io.Serializable;
import org.apache.commons.math3.special.Erf;
import weka.estimators.density.Kernel;

public class GaussianKernel
implements Kernel,
Serializable {
    private static final long serialVersionUID = -4439818887117815184L;

    @Override
    public double getKernelPDFValue(double x) {
        return Math.pow(Math.sqrt(Math.PI * 2), -1.0) * Math.exp(-0.5 * x * x);
    }

    @Override
    public double getKernelCDFValue(double x) {
        return 0.5 * (1.0 + Erf.erf((double)(x / Math.sqrt(2.0))));
    }

    public String toString() {
        return "Gaussian Kernel";
    }

    @Override
    public double supportLower() {
        return -4.0;
    }

    @Override
    public double supportUpper() {
        return 4.0;
    }
}

