/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators.density.kernels;

import java.io.Serializable;
import weka.estimators.density.Kernel;

public class GaussianKernelFast
implements Kernel,
Serializable {
    private static final long serialVersionUID = -4439818887117815184L;
    private double a = 0.1400122886866665;
    private double sqrtTwo = Math.sqrt(2.0);

    @Override
    public double getKernelPDFValue(double x) {
        return Math.pow(Math.sqrt(Math.PI * 2), -1.0) * Math.exp(-0.5 * x * x);
    }

    private double erfEstim(double x) {
        double xs = x * x;
        double axs = this.a * xs;
        double alpha = (1.2732395447351628 + axs) / (1.0 + axs);
        double erf = Math.signum(x) * Math.sqrt(1.0 - Math.exp(-alpha * xs));
        return erf;
    }

    @Override
    public double getKernelCDFValue(double x) {
        double val = 0.5 * (1.0 + this.erfEstim(x / this.sqrtTwo));
        return val;
    }

    public String toString() {
        return "Gaussian Kernel";
    }

    @Override
    public double supportLower() {
        return -4.0;
    }

    @Override
    public double supportUpper() {
        return 4.0;
    }
}

