/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators.density.kernels;

import java.io.Serializable;
import weka.estimators.density.Kernel;

public class QuarticKernel
implements Kernel,
Serializable {
    private static final long serialVersionUID = -6943481377417404445L;

    @Override
    public double getKernelPDFValue(double x) {
        if (x > -1.0 & x < 1.0) {
            return 0.9375 * (1.0 - x * x) * (1.0 - x * x);
        }
        return 0.0;
    }

    @Override
    public double getKernelCDFValue(double x) {
        if (x <= -1.0) {
            return 0.0;
        }
        if (x > -1.0 & x <= 1.0) {
            return 0.5 + 0.9375 * x - 0.625 * x * x * x + 0.1875 * x * x * x * x * x;
        }
        return 1.0;
    }

    public String toString() {
        return "Quartic Kernel";
    }

    @Override
    public double supportLower() {
        return -1.0;
    }

    @Override
    public double supportUpper() {
        return 1.0;
    }
}

