/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators.density.kernels;

import java.io.Serializable;
import weka.estimators.density.Kernel;

public class RectangularKernel
implements Kernel,
Serializable {
    private static final long serialVersionUID = -6604400066275755865L;

    @Override
    public double getKernelPDFValue(double x) {
        if (x >= -1.0 & x <= 1.0) {
            return 0.5;
        }
        return 0.0;
    }

    @Override
    public double getKernelCDFValue(double x) {
        if (x < -1.0) {
            return 0.0;
        }
        if (x > 1.0) {
            return 1.0;
        }
        return 0.5 * (x + 1.0);
    }

    public String toString() {
        return "Rectangular Kernel";
    }

    @Override
    public double supportLower() {
        return -1.0;
    }

    @Override
    public double supportUpper() {
        return 1.0;
    }
}

