/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators.density.kernels;

import java.io.Serializable;
import weka.estimators.density.Kernel;

public class TriangularKernel
implements Kernel,
Serializable {
    private static final long serialVersionUID = -5856076517421016587L;

    @Override
    public double getKernelPDFValue(double x) {
        if (x >= -1.0 & x <= 1.0) {
            return 1.0 - Math.abs(x);
        }
        return 0.0;
    }

    @Override
    public double getKernelCDFValue(double x) {
        if (x < -1.0) {
            return 0.0;
        }
        if (x >= -1.0 & x < 0.0) {
            return (x + 1.0) * (x + 1.0) / 2.0;
        }
        if (x >= 0.0 & x < 1.0) {
            return 1.0 - (1.0 - x) * (1.0 - x) / 2.0;
        }
        return 1.0;
    }

    public String toString() {
        return "Triangular Kernel";
    }

    @Override
    public double supportLower() {
        return -1.0;
    }

    @Override
    public double supportUpper() {
        return 1.0;
    }
}

