/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators.density.kernels;

import java.io.Serializable;
import weka.estimators.density.Kernel;

public class TriweightKernel
implements Kernel,
Serializable {
    private static final long serialVersionUID = -6943481377417404445L;

    @Override
    public double getKernelPDFValue(double x) {
        if (x > -1.0 & x < 1.0) {
            return 1.09375 * (1.0 - x * x) * (1.0 - x * x) * (1.0 - x * x);
        }
        return 0.0;
    }

    @Override
    public double getKernelCDFValue(double x) {
        if (x <= -1.0) {
            return 0.0;
        }
        if (x > -1.0 & x <= 1.0) {
            return 0.5 + 1.09375 * x - 1.09375 * x * x * x + 0.65625 * x * x * x * x * x - 0.15625 * x * x * x * x * x * x * x;
        }
        return 1.0;
    }

    public String toString() {
        return "Triweight Kernel";
    }

    @Override
    public double supportLower() {
        return -1.0;
    }

    @Override
    public double supportUpper() {
        return 1.0;
    }
}

