/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators.density.tools;

import java.io.Serializable;
import weka.core.Utils;
import weka.estimators.density.DensityEstimator;
import weka.tools.Linspace;

public class ROIFinder
implements Serializable {
    private static final long serialVersionUID = -5460027473493917508L;

    public static double[] findRoi(DensityEstimator estim, double lowerSearchBound, double upperSearchBound, int numSamples) {
        double[] roi = new double[2];
        double[] seq = Linspace.genLinspace(lowerSearchBound, upperSearchBound, numSamples);
        roi[0] = lowerSearchBound;
        roi[1] = upperSearchBound;
        boolean upperFound = false;
        double tmpCdf = 0.0;
        for (int i = 0; i < seq.length; ++i) {
            tmpCdf = estim.getCDF(seq[i]);
            if (Utils.eq((double)tmpCdf, (double)0.0)) {
                roi[0] = seq[Math.max(i - 1, 0)];
            }
            if (Utils.eq((double)tmpCdf, (double)1.0) & !upperFound) {
                roi[1] = seq[Math.min(i + 1, seq.length - 1)];
                upperFound = true;
            }
            if (!Utils.eq((double)roi[0], (double)roi[1])) continue;
            double delta = roi[0] / 2.0;
            roi[0] = roi[0] - delta;
            roi[1] = roi[1] + delta;
        }
        return roi;
    }
}

