/*
 * Decompiled with CFR 0.152.
 */
package weka.intPermutation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import weka.intPermutation.IntPermutationOperator;

public class IntPermutation
implements Serializable {
    private static final long serialVersionUID = -2740481993480858909L;
    private int[] permutation;
    private int min;
    private int max;

    public IntPermutation(int[] permutation) throws IllegalArgumentException {
        this.permutation = permutation;
        boolean isCorrect = this.isValid();
        if (!isCorrect) {
            this.min = 0;
            this.max = 0;
            this.permutation = null;
            throw new IllegalArgumentException("Permutation is inconsistent!");
        }
    }

    public IntPermutation(int len) throws IllegalArgumentException {
        this.permutation = IntPermutationOperator.genPermutation(0, len);
        this.min = 0;
        this.max = len - 1;
    }

    public int[] getArray() {
        return this.permutation;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public boolean isConsistentWith(IntPermutation perm) {
        boolean maxC;
        if (perm == null) {
            return false;
        }
        boolean minC = this.min == perm.getMin();
        boolean bl = maxC = this.max == perm.getMax();
        return minC && maxC;
    }

    public IntPermutation productPermutation(IntPermutation perm) throws IllegalArgumentException {
        boolean compl = this.isConsistentWith(perm);
        if (!compl) {
            throw new IllegalArgumentException("Permutations are not compatible!");
        }
        IntPermutation applied = null;
        int[] apPerm = new int[this.permutation.length];
        int[] trPerm = perm.getArray();
        for (int i = 0; i < this.permutation.length; ++i) {
            apPerm[i] = this.permutation[trPerm[i]];
        }
        applied = new IntPermutation(apPerm);
        return applied;
    }

    public List<Set<Integer>> findCycles() {
        IntPermutation baseP;
        IntPermutation tmpP = baseP = new IntPermutation(IntPermutationOperator.genPermutation(0, this.permutation.length));
        ArrayList cycleHashList = new ArrayList(this.permutation.length);
        for (int i = 0; i < this.permutation.length; ++i) {
            cycleHashList.add(new HashSet());
        }
        int[] tmpTab = null;
        do {
            tmpP = this.productPermutation(tmpP);
            tmpTab = tmpP.getArray();
            for (int i = 0; i < this.permutation.length; ++i) {
                ((Set)cycleHashList.get(i)).add(new Integer(tmpTab[i]));
            }
        } while (!baseP.equals(tmpP));
        LinkedList<Set<Integer>> finalCycles = new LinkedList<Set<Integer>>();
        boolean[] tabooTable = new boolean[this.permutation.length];
        for (int i = 0; i < this.permutation.length; ++i) {
            if (tabooTable[i]) continue;
            finalCycles.add((Set<Integer>)cycleHashList.get(i));
            for (Integer j : (Set)cycleHashList.get(i)) {
                tabooTable[j.intValue()] = true;
            }
        }
        return finalCycles;
    }

    public IntPermutation getInversePermutation() {
        int[] inverseTable = new int[this.permutation.length];
        int tmp = 0;
        int i = 0;
        while (i < this.permutation.length) {
            tmp = this.permutation[i];
            inverseTable[tmp] = i++;
        }
        return new IntPermutation(inverseTable);
    }

    public String toString() {
        StringBuilder desc = new StringBuilder("Permutation: ");
        for (int i = 0; i < this.permutation.length; ++i) {
            if (i == this.permutation.length - 1) {
                desc.append(this.permutation[i]);
                continue;
            }
            desc.append(this.permutation[i] + ", ");
        }
        return desc.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntPermutation)) {
            return false;
        }
        IntPermutation testObj = (IntPermutation)obj;
        int[] testTab = testObj.getArray();
        for (int i = 0; i < this.permutation.length; ++i) {
            if (this.permutation[i] == testTab[i]) continue;
            return false;
        }
        return true;
    }

    private boolean isValid() {
        boolean positive = true;
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
        if (this.permutation == null) {
            return false;
        }
        int[] perm = this.permutation;
        for (int i = 0; i < perm.length; ++i) {
            if (perm[i] < 0) {
                positive = false;
                break;
            }
            if (perm[i] < this.min) {
                this.min = perm[i];
            }
            if (perm[i] <= this.max) continue;
            this.max = perm[i];
        }
        if (!positive) {
            return false;
        }
        if (this.min != 0) {
            return false;
        }
        if (this.max != this.min + perm.length - 1) {
            return false;
        }
        int[] counts = new int[perm.length];
        boolean cover = true;
        for (int i = 0; i < perm.length; ++i) {
            int n = perm[i] - this.min;
            counts[n] = counts[n] + 1;
            if (counts[perm[i] - this.min] <= 1) continue;
            cover = false;
            break;
        }
        return cover;
    }

    public void shufflePermutation(int seed) {
        this.permutation = IntPermutationOperator.shufflePermutation(this.permutation, seed);
    }
}

