/*
 * Decompiled with CFR 0.152.
 */
package weka.intPermutation.distance;

import java.io.Serializable;
import weka.intPermutation.IntPermutation;
import weka.intPermutation.distance.IntPermDistanceCalc;

public class AdjacencyDistance
implements IntPermDistanceCalc,
Serializable {
    private static final long serialVersionUID = 4357013726797573177L;

    @Override
    public double calculateDistance(IntPermutation perm1, IntPermutation perm2) throws Exception {
        boolean areConsistent = perm1.isConsistentWith(perm2);
        if (!areConsistent) {
            throw new IllegalArgumentException("Permuatations are incconsistent");
        }
        int[][] adjMatrix1 = this.generateAdjacencyMatrix(perm1);
        int[][] adjMatrix2 = this.generateAdjacencyMatrix(perm2);
        int len = perm1.getArray().length;
        double nadj = 0.0;
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < len; ++j) {
                if (i == j || adjMatrix1[i][j] != 1 || adjMatrix2[i][j] != 1) continue;
                nadj += 1.0;
            }
        }
        double maxVal = len - 1;
        double dist = (maxVal - nadj) / maxVal;
        return dist;
    }

    protected int[][] generateAdjacencyMatrix(IntPermutation perm) {
        int[] pTab = perm.getArray();
        int[][] adjMatrix = new int[pTab.length][pTab.length];
        for (int i = 0; i < pTab.length - 1; ++i) {
            adjMatrix[pTab[i]][pTab[i + 1]] = 1;
        }
        return adjMatrix;
    }

    @Override
    public double getMaxDist() {
        return 1.0;
    }

    @Override
    public double getMinDist() {
        return 0.0;
    }
}

