/*
 * Decompiled with CFR 0.152.
 */
package weka.intPermutation.distance;

import java.io.Serializable;
import weka.intPermutation.IntPermutation;
import weka.intPermutation.distance.IntPermDistanceCalc;

public class CayleyDistance
implements IntPermDistanceCalc,
Serializable {
    private static final long serialVersionUID = -2779821804474197715L;

    @Override
    public double calculateDistance(IntPermutation perm1, IntPermutation perm2) throws Exception {
        boolean areConsistent = perm1.isConsistentWith(perm2);
        if (!areConsistent) {
            throw new IllegalArgumentException("Permuatations are incconsistent");
        }
        IntPermutation tmp = perm2.productPermutation(perm1.getInversePermutation());
        int nCycles = tmp.findCycles().size();
        double maxValue = perm1.getArray().length - 1;
        double result = (maxValue - (double)nCycles + 1.0) / maxValue;
        return result;
    }

    @Override
    public double getMaxDist() {
        return 1.0;
    }

    @Override
    public double getMinDist() {
        return 0.0;
    }
}

