/*
 * Decompiled with CFR 0.152.
 */
package weka.intPermutation.distance;

import java.io.Serializable;
import weka.intPermutation.IntPermutation;
import weka.intPermutation.distance.IntPermDistanceCalc;

public class HammingDistance
implements IntPermDistanceCalc,
Serializable {
    private static final long serialVersionUID = -3298066083924955783L;

    @Override
    public double calculateDistance(IntPermutation perm1, IntPermutation perm2) throws Exception {
        boolean areConsistent = perm1.isConsistentWith(perm2);
        if (!areConsistent) {
            throw new IllegalArgumentException("Permuatations are incconsistent");
        }
        int[] p1Tab = perm1.getArray();
        int[] p2Tab = perm2.getArray();
        int len = p1Tab.length;
        double errCnt = 0.0;
        for (int i = 0; i < len; ++i) {
            if (p1Tab[i] == p2Tab[i]) continue;
            errCnt += 1.0;
        }
        return errCnt / (double)len;
    }

    @Override
    public double getMaxDist() {
        return 1.0;
    }

    @Override
    public double getMinDist() {
        return 0.0;
    }
}

