/*
 * Decompiled with CFR 0.152.
 */
package weka.intPermutation.distance;

import java.util.Collection;
import java.util.Iterator;
import weka.intPermutation.IntPermutation;
import weka.intPermutation.distance.IntPermDistanceCalc;
import weka.intPermutation.distance.IntPermSetObjectDistance;

public class SetObjDistanceCalculator
implements IntPermSetObjectDistance {
    protected IntPermDistanceCalc distCalc;

    public SetObjDistanceCalculator(IntPermDistanceCalc distCalc) {
        this.distCalc = distCalc;
    }

    @Override
    public double calculateAverageDistance(IntPermutation obj, IntPermutation[] set) throws Exception {
        double result = 0.0;
        int setSize = set.length;
        for (int i = 0; i < setSize; ++i) {
            result += this.distCalc.calculateDistance(obj, set[i]);
        }
        return result /= (double)setSize;
    }

    @Override
    public double calculateAverageDistance(IntPermutation obj, Collection<IntPermutation> set) throws Exception {
        double result = 0.0;
        int setSize = set.size();
        Iterator<IntPermutation> itr = set.iterator();
        while (itr.hasNext()) {
            result += this.distCalc.calculateDistance(obj, itr.next());
        }
        return result /= (double)setSize;
    }

    @Override
    public double getMaxValue() {
        return this.distCalc.getMaxDist();
    }

    @Override
    public double getMinValue() {
        return this.distCalc.getMinDist();
    }
}

