/*
 * Decompiled with CFR 0.152.
 */
package weka.intPermutation.distance;

import java.io.Serializable;
import weka.intPermutation.IntPermutation;
import weka.intPermutation.distance.IntPermDistanceCalc;

public class UlamDistance
implements IntPermDistanceCalc,
Serializable {
    private static final long serialVersionUID = -6697146741187272994L;

    @Override
    public double calculateDistance(IntPermutation perm1, IntPermutation perm2) throws Exception {
        boolean areConsistent = perm1.isConsistentWith(perm2);
        if (!areConsistent) {
            throw new IllegalArgumentException("Permuatations are incconsistent");
        }
        IntPermutation tmp = perm2.productPermutation(perm1.getInversePermutation());
        int longestIncSeqLen = this.longestIncreasingSequence(tmp).length;
        double maxValue = perm1.getArray().length;
        double result = (maxValue - (double)longestIncSeqLen) / maxValue;
        return result;
    }

    private int[] longestIncreasingSequence(IntPermutation perm) {
        int[] longestIncSeq = null;
        int[] X = perm.getArray();
        int pSeqLen = X.length;
        int[] P = new int[pSeqLen];
        int[] M = new int[pSeqLen + 1];
        int L = 0;
        for (int i = 0; i < pSeqLen; ++i) {
            int lo = 1;
            int hi = L;
            while (lo <= hi) {
                int mid = (int)Math.ceil((double)(hi + lo) / 2.0);
                if (X[M[mid]] < X[i]) {
                    lo = mid + 1;
                    continue;
                }
                hi = mid - 1;
            }
            int newL = lo;
            P[i] = M[newL - 1];
            M[newL] = i;
            if (newL <= L) continue;
            L = newL;
        }
        longestIncSeq = new int[L];
        int k = M[L];
        for (int i = L - 1; i >= 0; --i) {
            longestIncSeq[i] = X[k];
            k = P[k];
        }
        return longestIncSeq;
    }

    @Override
    public double getMaxDist() {
        return 1.0;
    }

    @Override
    public double getMinDist() {
        return 0.0;
    }
}

