/*
 * Decompiled with CFR 0.152.
 */
package weka.tools;

import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class InstancesTools {
    public static int[] getClassCounts(Instances dataset) {
        int numClass = dataset.numClasses();
        int numInstances = dataset.numInstances();
        int[] instCount = new int[numClass];
        for (int i = 0; i < numInstances; ++i) {
            int n = (int)dataset.get(i).classValue();
            instCount[n] = instCount[n] + 1;
        }
        return instCount;
    }

    public static boolean checkCompatibility(Instances dataset, Instance inst) throws Exception {
        if (dataset == inst.dataset()) {
            return true;
        }
        int numAttribs = dataset.numAttributes();
        if (inst.numAttributes() != numAttribs) {
            throw new Exception("Incompatible number of attributes");
        }
        if (inst.classIndex() != dataset.classIndex()) {
            throw new Exception("The class index does not match");
        }
        for (int a = 0; a < numAttribs; ++a) {
            Attribute setAttr;
            Attribute instAttr = inst.attribute(a);
            String msg = instAttr.equalsMsg((Object)(setAttr = dataset.attribute(a)));
            if (msg == null) continue;
            throw new Exception(msg);
        }
        return true;
    }

    public static boolean checkCompatibility(Instance inst1, Instance inst2) throws Exception {
        if (inst1.dataset() == inst2.dataset()) {
            return true;
        }
        int numAttribs = inst1.numAttributes();
        if (inst2.numAttributes() != numAttribs) {
            throw new Exception("Incompatible number of attributes");
        }
        if (inst2.classIndex() != inst1.classIndex()) {
            throw new Exception("The class index does not match");
        }
        for (int a = 0; a < numAttribs; ++a) {
            Attribute inst1Attr;
            Attribute inst2Attr = inst2.attribute(a);
            String msg = inst2Attr.equalsMsg((Object)(inst1Attr = inst1.attribute(a)));
            if (msg == null) continue;
            throw new Exception(msg);
        }
        return true;
    }

    public static boolean checkEquall(Instance inst1, Instance inst2, boolean checkClass) throws Exception {
        if (!InstancesTools.checkCompatibility(inst1, inst2)) {
            return false;
        }
        Instances dataset = inst1.dataset();
        int numAttrs = dataset.numAttributes();
        double[] rep1 = inst1.toDoubleArray();
        double[] rep2 = inst2.toDoubleArray();
        int classIdx = dataset.classIndex();
        for (int a = 0; a < numAttrs; ++a) {
            if (a == classIdx && !checkClass || Utils.eq((double)rep1[a], (double)rep2[a])) continue;
            return false;
        }
        return true;
    }

    public static Instance copyInstance(Instance inst) {
        Instance result = inst.copy(inst.toDoubleArray());
        return result;
    }
}

