/*
 * Decompiled with CFR 0.152.
 */
package weka.tools.data;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.Random;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.Standardize;
import weka.filters.unsupervised.instance.Resample;
import weka.filters.unsupervised.instance.SparseToNonSparse;

public class InstancesOperator {
    public static Instances generateBaggingSample(Instances baseSet, int seed, double percentage) throws Exception {
        Resample resample = new Resample();
        resample.setNoReplacement(false);
        double finalPerc = 100.0 * percentage;
        resample.setSampleSizePercent(finalPerc);
        resample.setRandomSeed(seed);
        Instances resampledI = null;
        try {
            resample.setInputFormat(baseSet);
            resampledI = Filter.useFilter((Instances)baseSet, (Filter)resample);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return resampledI;
    }

    public static Instances generateBaggingSample(Instances baseSet, int seed) throws Exception {
        return InstancesOperator.generateBaggingSample(baseSet, seed, 1.0);
    }

    public static Instances generateBaggingSample(Instances baseSet) throws Exception {
        return InstancesOperator.generateBaggingSample(baseSet, 1);
    }

    public static Instances[] splitSet(Instances inputSet, double splitCoeff, int seed) {
        Instances[] splittedInstances = new Instances[2];
        int instancesNumber = inputSet.numInstances();
        if (instancesNumber == 0) {
            splittedInstances[0] = new Instances(inputSet);
            splittedInstances[1] = new Instances(inputSet);
            return splittedInstances;
        }
        int leftIdx = (int)Math.floor((double)instancesNumber * splitCoeff);
        int rigthIdx = leftIdx + 1;
        Instances shuffledSet = new Instances(inputSet);
        shuffledSet.randomize(new Random(seed));
        splittedInstances[0] = new Instances(shuffledSet, 0, leftIdx + 1);
        splittedInstances[1] = new Instances(shuffledSet, rigthIdx, instancesNumber - rigthIdx);
        return splittedInstances;
    }

    public static Instances[] stratifiedSplitSet(Instances inputSet, double splitCoeff, int seed) {
        Instances[] splittedInstances = new Instances[2];
        int numInstances = inputSet.numInstances();
        int numClasses = inputSet.numClasses();
        int[] classCounts = new int[numClasses];
        for (int i = 0; i < numInstances; ++i) {
            int n = (int)inputSet.get(i).classValue();
            classCounts[n] = classCounts[n] + 1;
        }
        int[] classCountsA = new int[numClasses];
        int[] classCountsB = new int[numClasses];
        for (int i = 0; i < numClasses; ++i) {
            classCountsA[i] = (int)Math.round((double)classCounts[i] * splitCoeff);
            classCountsB[i] = (int)Math.round((double)classCounts[i] * (1.0 - splitCoeff));
        }
        int setACard = (int)Math.floor((double)numInstances * splitCoeff);
        int setBCard = numInstances - setACard;
        splittedInstances[0] = new Instances(inputSet, setACard);
        splittedInstances[1] = new Instances(inputSet, setBCard);
        Instance tmpInstance = null;
        int selClass = 0;
        for (int i = 0; i < numInstances; ++i) {
            tmpInstance = inputSet.get(i);
            selClass = (int)tmpInstance.classValue();
            if (classCountsA[selClass] > 0) {
                int n = selClass;
                classCountsA[n] = classCountsA[n] - 1;
                splittedInstances[0].add((Instance)tmpInstance.copy());
                continue;
            }
            if (classCountsB[selClass] <= 0) continue;
            int n = selClass;
            classCountsB[n] = classCountsB[n] - 1;
            splittedInstances[1].add((Instance)tmpInstance.copy());
        }
        return splittedInstances;
    }

    public static Instances[] splitSet(Instances inputSet, double splitCoeff) {
        return InstancesOperator.splitSet(inputSet, splitCoeff, 1);
    }

    public static Instances[] splItSet(Instances inputSet, int firstSetNum) {
        Instances[] splittedInstances = new Instances[2];
        int instancesNumber = inputSet.numInstances();
        int leftIdx = firstSetNum;
        int rigthIdx = leftIdx + 1;
        Instances shuffledSet = inputSet;
        splittedInstances[0] = new Instances(shuffledSet, 0, leftIdx + 1);
        splittedInstances[1] = new Instances(shuffledSet, rigthIdx, instancesNumber - rigthIdx);
        return splittedInstances;
    }

    public static Instances normalizeData(Instances inputSet) throws Exception {
        Normalize normalizer = new Normalize();
        normalizer.setInputFormat(inputSet);
        return Filter.useFilter((Instances)inputSet, (Filter)normalizer);
    }

    public static Instances standarizeData(Instances inputSet) throws Exception {
        Standardize standarize = new Standardize();
        standarize.setInputFormat(inputSet);
        return Filter.useFilter((Instances)inputSet, (Filter)standarize);
    }

    public static Instances desparse(Instances inputSet) throws Exception {
        SparseToNonSparse sprFilter = new SparseToNonSparse();
        sprFilter.setInputFormat(inputSet);
        return Filter.useFilter((Instances)inputSet, (Filter)sprFilter);
    }

    public static int[] objPerClass(Instances inputSet) throws Exception {
        int numClass = inputSet.numClasses();
        int numInstances = inputSet.numInstances();
        int[] classCnts = new int[numClass];
        Instance tmpInstance = null;
        for (int i = 0; i < numInstances; ++i) {
            int classIdx;
            tmpInstance = inputSet.get(i);
            int n = classIdx = (int)tmpInstance.classValue();
            classCnts[n] = classCnts[n] + 1;
        }
        return classCnts;
    }

    public static double[] classFreq(Instances inputSet) throws Exception {
        int i;
        int numClass = inputSet.numClasses();
        int numInstances = inputSet.numInstances();
        double[] classFreqs = new double[numClass];
        Instance tmpInstance = null;
        for (i = 0; i < numInstances; ++i) {
            int classIdx;
            tmpInstance = inputSet.get(i);
            int n = classIdx = (int)tmpInstance.classValue();
            classFreqs[n] = classFreqs[n] + 1.0;
        }
        i = 0;
        while (i < classFreqs.length) {
            int n = i++;
            classFreqs[n] = classFreqs[n] / (double)numInstances;
        }
        return classFreqs;
    }

    public static Instances[] classSpecSplit(Instances input) throws Exception {
        Attribute classAttr = input.classAttribute();
        if (!classAttr.isNominal() && !classAttr.isString()) {
            throw new Exception("Incompatible class atribute");
        }
        int numClasses = input.numClasses();
        Instances[] results = new Instances[numClasses];
        for (int c = 0; c < numClasses; ++c) {
            results[c] = new Instances(input, 0);
        }
        int instNum = input.numInstances();
        int classVal = 0;
        for (int i = 0; i < instNum; ++i) {
            Instance tmpInstance = input.get(i);
            classVal = (int)tmpInstance.classValue();
            results[classVal].add(tmpInstance);
        }
        return results;
    }

    public static void main(String[] args) {
        System.out.println("Instances Operator Test: ");
        String file = new String("./data/iris.arff");
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            Instances dat = new Instances((Reader)reader);
            dat.setClass(dat.attribute(dat.numAttributes() - 1));
            Instances[] sInst = null;
            sInst = InstancesOperator.splitSet(dat, 0.7);
            System.out.println("S0: " + sInst[0].numInstances());
            System.out.println("S1: " + sInst[1].numInstances());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

