/*
 * Decompiled with CFR 0.152.
 */
package weka.tools.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Randomizable;
import weka.tools.data.DataGenerator;

public class RandomDataGenerator
implements Serializable,
DataGenerator,
Randomizable {
    private static final long serialVersionUID = -4367823102888277085L;
    private int numNumericAttributes = 2;
    private int numNominalAttributes = 2;
    private int numObjects = 100;
    private int maxNumNominalValues = 3;
    private String numericAttribNameProto = "NumA";
    private String nominalAttribNameProto = "NomA";
    private int seed = 0;
    private Random rnd = new Random(this.seed);
    private boolean addClassAttrib = true;
    private int numClasses = 2;
    private boolean allowUnary = false;

    @Override
    public Instances generateData() {
        ArrayList<Attribute> atts = new ArrayList<Attribute>(3);
        this.generateNumericAttribs(atts);
        this.generateNominalAttribs(atts);
        this.generateClass(atts);
        Instances dataset = null;
        dataset = new Instances("dataset", atts, 1);
        if (this.addClassAttrib) {
            dataset.setClassIndex(dataset.numAttributes() - 1);
        }
        this.fillWithInstances(dataset);
        return dataset;
    }

    protected void generateNumericAttribs(List<Attribute> attrList) {
        for (int i = 0; i < this.numNumericAttributes; ++i) {
            attrList.add(new Attribute(this.numericAttribNameProto + i));
        }
    }

    protected void generateNominalAttribs(List<Attribute> attrList) {
        for (int a = 0; a < this.numNominalAttributes; ++a) {
            int numVals = this.rnd.nextInt(this.maxNumNominalValues) + 1;
            if (numVals == 1 & !this.allowUnary) {
                ++numVals;
            }
            LinkedList<String> valList = new LinkedList<String>();
            for (int v = 0; v < numVals; ++v) {
                valList.add("" + v);
            }
            attrList.add(new Attribute(this.nominalAttribNameProto + a, valList));
        }
    }

    protected void generateClass(List<Attribute> attrList) {
        if (!this.addClassAttrib) {
            return;
        }
        LinkedList<String> valList = new LinkedList<String>();
        for (int v = 0; v < this.numClasses; ++v) {
            valList.add("" + v);
        }
        attrList.add(new Attribute("Class", valList));
    }

    protected void fillWithInstances(Instances dataset) {
        int numAttrs = dataset.numAttributes();
        for (int i = 0; i < this.numObjects; ++i) {
            Attribute tmpAttr = null;
            double[] instanceRep = new double[numAttrs];
            for (int a = 0; a < numAttrs; ++a) {
                tmpAttr = dataset.attribute(a);
                if (tmpAttr.isNumeric()) {
                    instanceRep[a] = this.rnd.nextDouble();
                    continue;
                }
                if (!tmpAttr.isNominal()) continue;
                int numVals = tmpAttr.numValues();
                instanceRep[a] = this.rnd.nextInt(numVals);
            }
            dataset.add((Instance)new DenseInstance(1.0, instanceRep));
        }
    }

    public int getNumNumericAttributes() {
        return this.numNumericAttributes;
    }

    public void setNumNumericAttributes(int numNumericAttributes) {
        this.numNumericAttributes = numNumericAttributes;
    }

    public int getNumNominalAttributes() {
        return this.numNominalAttributes;
    }

    public void setNumNominalAttributes(int numNominalAttributes) {
        this.numNominalAttributes = numNominalAttributes;
    }

    public int getNumObjects() {
        return this.numObjects;
    }

    public void setNumObjects(int numObjects) {
        this.numObjects = numObjects;
    }

    public int getMaxNumNominalValues() {
        return this.maxNumNominalValues;
    }

    public void setMaxNumNominalValues(int maxNumNominalValues) {
        this.maxNumNominalValues = maxNumNominalValues;
    }

    public void setSeed(int seed) {
        this.seed = seed;
        this.rnd.setSeed(seed);
    }

    public int getSeed() {
        return this.seed;
    }

    public boolean isAddClassAttrib() {
        return this.addClassAttrib;
    }

    public void setAddClassAttrib(boolean addClassAttrib) {
        this.addClassAttrib = addClassAttrib;
    }

    public int getNumClasses() {
        return this.numClasses;
    }

    public void setNumClasses(int numClasses) {
        this.numClasses = numClasses;
    }

    public boolean isAllowUnary() {
        return this.allowUnary;
    }

    public void setAllowUnary(boolean allowUnary) {
        this.allowUnary = allowUnary;
    }
}

