/*
 * Decompiled with CFR 0.152.
 */
package weka.tools.numericIntegration;

import weka.tools.Linspace;
import weka.tools.numericIntegration.AIntegrator;

public abstract class SimpleIntegrator
extends AIntegrator {
    private static final long serialVersionUID = -7365946408256340706L;
    protected double delta = 9.99000999000999E-4;
    protected int sequenceLength = 1001;

    public double getDelta() {
        return this.delta;
    }

    public void setDelta(double delta) {
        this.delta = delta;
        this.sequenceLength = (int)Math.ceil((this.getUpperBound() - this.getLowerBound()) / this.delta);
    }

    public int getSequenceLength() {
        return this.sequenceLength;
    }

    public void setSequenceLength(int sequenceLength) {
        this.sequenceLength = sequenceLength;
        this.delta = (this.getUpperBound() - this.getLowerBound()) / (double)sequenceLength;
    }

    protected double[] generateSequence() {
        return Linspace.genLinspace(this.getLowerBound(), this.getUpperBound(), this.sequenceLength);
    }

    @Override
    public void setLowerBound(double lower) {
        super.setLowerBound(lower);
        this.setSequenceLength(this.sequenceLength);
    }

    @Override
    public void setUpperBound(double upper) {
        super.setUpperBound(upper);
        this.setSequenceLength(this.sequenceLength);
    }
}

