/*
 * Decompiled with CFR 0.152.
 */
package weka.tools.tests;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Vector;
import weka.core.CheckGOE;
import weka.core.OptionMetadata;
import weka.gui.ProgrammaticProperty;

public class WekaGOEChecker
extends CheckGOE {
    public boolean checkCallGlobalInfo() {
        Object obj = this.getObject();
        boolean result = true;
        Class<?> cls = obj.getClass();
        try {
            Method method = cls.getMethod("globalInfo", null);
            method.setAccessible(true);
            String globalInfo = (String)method.invoke(obj, null);
            if (globalInfo.length() == 0) {
                result = false;
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean checkToolTipsCall() {
        PropertyDescriptor[] desc;
        this.print("Tool tips...");
        boolean result = true;
        String suffix = "TipText";
        Class<?> cls = this.getObject().getClass();
        try {
            BeanInfo info = Introspector.getBeanInfo(cls, Object.class);
            desc = info.getPropertyDescriptors();
        }
        catch (Exception e) {
            e.printStackTrace();
            desc = null;
        }
        if (desc != null) {
            Vector<String> missing = new Vector<String>();
            for (int i = 0; i < desc.length; ++i) {
                if (this.m_IgnoredProperties.contains(desc[i].getName()) || desc[i].getReadMethod() == null || desc[i].getWriteMethod() == null) continue;
                OptionMetadata m = desc[i].getReadMethod().getAnnotation(OptionMetadata.class);
                if (m == null) {
                    m = desc[i].getWriteMethod().getAnnotation(OptionMetadata.class);
                }
                if (m != null) continue;
                ProgrammaticProperty p = desc[i].getReadMethod().getAnnotation(ProgrammaticProperty.class);
                if (p == null) {
                    p = desc[i].getWriteMethod().getAnnotation(ProgrammaticProperty.class);
                }
                if (p != null) continue;
                try {
                    Method method = cls.getMethod(desc[i].getName() + suffix, null);
                    method.setAccessible(true);
                    String tipText = (String)method.invoke(this.getObject(), null);
                    if (tipText.length() != 0) continue;
                    result = false;
                    continue;
                }
                catch (Exception e) {
                    result = false;
                    missing.add(desc[i].getName() + suffix);
                }
            }
            if (result) {
                this.println("yes");
            } else {
                this.println("no (missing: " + missing + ")");
            }
        } else {
            this.println("maybe");
            result = false;
        }
        return result;
    }
}

