/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptvlogistics.log4jala;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.ptvlogistics.log4jala.ALAThreadFactoryBuilder;
import com.github.ptvlogistics.log4jala.Log4jALAAppender;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;

public class HTTPDataCollector {
    private String workspaceId;
    private String sharedKey;
    private byte[] sharedKeyBytes;
    private ExecutorService executorService;
    private ObjectMapper jsonMapper = new ObjectMapper();
    private Log4jALAAppender appender;
    private String proxyHost;
    private Integer proxyPort;

    public HTTPDataCollector(String workspaceId, String sharedKey, int asyncThreadPoolSize, Log4jALAAppender appender, String proxyHost, Integer proxyPort) {
        this.appender = appender;
        if (this.executorService == null || this.executorService.isTerminated()) {
            ThreadFactory threadFactory = new ALAThreadFactoryBuilder().setNameFormat("AlaHTTDataCollector-Thread").setDaemon(true).build();
            this.executorService = Executors.newFixedThreadPool(asyncThreadPoolSize, threadFactory);
        }
        this.workspaceId = workspaceId;
        this.sharedKey = sharedKey;
        this.sharedKeyBytes = Base64.getDecoder().decode(this.sharedKey);
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public void collect(final String logType, final Object objectToSerialize, final String apiVersion, final String timeGeneratedPropertyName) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    HTTPDataCollector.this.sendHTTPDataCollectorAPIRequest(logType, HTTPDataCollector.this.jsonMapper.writeValueAsString(objectToSerialize), apiVersion, timeGeneratedPropertyName);
                }
                catch (Exception e) {
                    HTTPDataCollector.this.appender.logError("Unexpected exception while sending data to Azure Log Analytics by the HTTP Data Collector API.", e);
                }
            }
        });
    }

    public void collect(final String logType, final String jsonPayload, final String apiVersion, final String timeGeneratedPropertyName) throws Exception {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    HTTPDataCollector.this.sendHTTPDataCollectorAPIRequest(logType, jsonPayload, apiVersion, timeGeneratedPropertyName);
                }
                catch (Exception e) {
                    HTTPDataCollector.this.appender.logError("Unexpected exception while sending data to Azure Log Analytics by the HTTP Data Collector API.", e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHTTPDataCollectorAPIRequest(String logType, String jsonPayload, String apiVersion, String timeGeneratedPropertyName) throws Exception {
        try (CloseableHttpClient client = null;){
            CloseableHttpResponse response;
            String url = "https://" + this.workspaceId + ".ods.opinsights.azure.com/api/logs?api-version=" + apiVersion;
            String rfcDate = DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now(ZoneId.of("GMT")));
            CharSequence[] rfcSplitted = rfcDate.split("\\s+");
            if (rfcSplitted[1].length() == 1) {
                rfcSplitted[1] = "0" + rfcSplitted[1];
                rfcDate = String.join((CharSequence)" ", rfcSplitted);
            }
            String signature = this.hashSignature("POST", jsonPayload.length(), "application/json", rfcDate, "/api/logs");
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (certificate, authType) -> true).build();
            client = this.proxyHost == null || this.proxyPort == null ? HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).setRetryHandler((exception, executionCount, context) -> executionCount < (Integer)context.getAttribute("retry.count")).build() : HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).setRetryHandler((exception, executionCount, context) -> executionCount < (Integer)context.getAttribute("retry.count")).setProxy(new HttpHost(this.proxyHost, this.proxyPort.intValue())).build();
            HttpClientContext clientContext = HttpClientContext.create();
            clientContext.setAttribute("retry.count", (Object)6);
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(jsonPayload, "UTF8");
            entity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setHeader("Log-Type", logType);
            httpPost.setHeader("x-ms-date", rfcDate);
            httpPost.setHeader("Authorization", signature);
            if (StringUtils.isNotEmpty((CharSequence)timeGeneratedPropertyName)) {
                httpPost.setHeader("time-generated-field", timeGeneratedPropertyName);
            }
            if ((response = client.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode() != 200) {
                this.appender.logError(String.format("Warn sendHTTPDataCollectorAPIRequest [%s] [%s]", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()), new Exception("warn"));
            }
        }
    }

    public void close() {
        if (this.executorService != null) {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(800L, TimeUnit.MILLISECONDS)) {
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.executorService.shutdownNow();
            }
        }
    }

    private String hashSignature(String method, int contentLength, String contentType, String date, String resource) throws Exception {
        String stringtoHash = method + "\n" + contentLength + "\n" + contentType + "\nx-ms-date:" + date + "\n" + resource;
        byte[] bytesToHash = stringtoHash.getBytes(StandardCharsets.UTF_8);
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(this.sharedKeyBytes, "HmacSHA256");
        sha256_HMAC.init(secret_key);
        byte[] calculatedHash = sha256_HMAC.doFinal(bytesToHash);
        String stringHash = Base64.getEncoder().encodeToString(calculatedHash);
        return "SharedKey " + this.workspaceId + ":" + stringHash;
    }
}

