/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptvlogistics.log4jala;

import com.github.ptvlogistics.log4jala.HTTPDataCollector;
import com.github.ptvlogistics.log4jala.LoggingEventSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.LoggingEvent;

public class Log4jALAAppender
extends AppenderSkeleton {
    private String workspaceId;
    private String sharedKey;
    private String logType;
    private String azureApiVersion;
    private String component;
    private String version;
    private String environment;
    private int threadPoolSize;
    private String proxyHost;
    private Integer proxyPort;
    private Boolean appendLogger;
    private Boolean appendLogLevel;
    private static HTTPDataCollector httpDataCollector;
    private LoggingEventSerializer serializer;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public String getSharedKey() {
        return this.sharedKey;
    }

    public void setSharedKey(String sharedKey) {
        this.sharedKey = sharedKey;
    }

    public String getLogType() {
        return this.logType;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public String getAzureApiVersion() {
        return this.azureApiVersion;
    }

    public void setAzureApiVersion(String azureApiVersion) {
        this.azureApiVersion = azureApiVersion;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public boolean getAppendLogger() {
        return this.appendLogger == null ? true : this.appendLogger;
    }

    public void setAppendLogger(boolean appendLogger) {
        this.appendLogger = appendLogger;
    }

    public boolean getAppendLogLevel() {
        return this.appendLogLevel == null ? true : this.appendLogLevel;
    }

    public void setAppendLogLevel(boolean appendLogLevel) {
        this.appendLogLevel = appendLogLevel;
    }

    public void activateOptions() {
        try {
            if (httpDataCollector != null) {
                this.close();
            }
            if (StringUtils.isEmpty((CharSequence)this.workspaceId)) {
                throw new Exception(String.format("the Log4jALAAppender property workspaceId [%s] shouldn't be empty (log4j.xml)", this.workspaceId));
            }
            if (StringUtils.isEmpty((CharSequence)this.sharedKey)) {
                throw new Exception(String.format("the Log4jALAAppender property sharedKey [%s] shouldn't be empty (log4j.xml)", this.sharedKey));
            }
            if (StringUtils.isEmpty((CharSequence)this.logType)) {
                throw new Exception(String.format("the Log4jALAAppender property logType [%s] shouldn't be empty (log4j.xml)", this.logType));
            }
            this.serializer = new LoggingEventSerializer();
            httpDataCollector = new HTTPDataCollector(this.workspaceId, this.sharedKey, this.threadPoolSize <= 0 ? 1000 : this.threadPoolSize, this, this.proxyHost, this.proxyPort);
        }
        catch (Exception e) {
            this.errorHandler.error("Unexpected exception while initialising HTTPDataCollector.", e, 0);
        }
    }

    protected void append(LoggingEvent loggingEvent) {
        try {
            if (httpDataCollector != null) {
                String content = this.serializer.serializeLoggingEvents(new ArrayList<LoggingEvent>(Arrays.asList(loggingEvent)), this);
                httpDataCollector.collect(this.logType, content, StringUtils.isEmpty((CharSequence)this.azureApiVersion) ? "2016-04-01" : this.azureApiVersion, "DateValue");
            } else {
                this.errorHandler.error("Couldn't append log message during the HTTPDataCollector isn't initialized.");
            }
        }
        catch (Exception ex) {
            this.logError(String.format("Unable to send data to Azure Log Analytics: %1s", ex.getMessage()), ex);
        }
    }

    public void close() {
        httpDataCollector.close();
    }

    public void logError(String message, Exception e) {
        this.errorHandler.error(message, e, 0);
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        super.setErrorHandler(errorHandler);
    }

    public ErrorHandler getErrorHandler() {
        return super.getErrorHandler();
    }
}

