/*
 * Decompiled with CFR 0.152.
 */
package com.github.pudovika;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;

public class UglifyMojo
extends AbstractMojo {
    private String encoding = "UTF-8";
    protected FileSet sources;
    protected FileSet cssSources;
    protected File outputDirectory;
    protected boolean skip = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping");
            return;
        }
        if (this.outputDirectory == null) {
            throw new MojoExecutionException("outputDirectory is not specified.");
        }
        try {
            int count = this.uglify(this.getJsSourceFiles());
            this.getLog().info((CharSequence)("Uglified " + count + " file(s)."));
            if (this.cssSources != null) {
                count = this.cleanCss(this.getCssSourceFiles());
                this.getLog().info((CharSequence)("Celeaned " + count + " file(s)."));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failure to precompile handlebars templates.", (Exception)e);
        }
    }

    protected int uglify(File[] jsFiles) throws IOException {
        int count = 0;
        for (File jsFile : jsFiles) {
            String jsFilePath = jsFile.getPath();
            this.getLog().info((CharSequence)("Uglifying " + jsFilePath));
            try {
                Process p = Runtime.getRuntime().exec("uglifyjs " + jsFilePath + " -o " + this.getOutputFile(jsFile).getPath());
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Could not uglify " + jsFile.getPath() + "."), (Throwable)e);
                throw e;
            }
            ++count;
        }
        return count;
    }

    protected int cleanCss(File[] cssFiles) throws IOException {
        int count = 0;
        for (File cssFile : cssFiles) {
            String cssFilePath = cssFile.getPath();
            this.getLog().info((CharSequence)("Cleaning Css " + cssFilePath));
            try {
                Process p = Runtime.getRuntime().exec("cleancss " + cssFilePath + " -o " + this.getOutputFile(cssFile).getPath());
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Could not clean css " + cssFile.getPath() + "."), (Throwable)e);
                throw e;
            }
            ++count;
        }
        return count;
    }

    private final File getOutputFile(File inputFile) throws IOException {
        String relativePath = this.getSourceDir().toURI().relativize(inputFile.getParentFile().toURI()).getPath();
        File outputBaseDir = new File(this.outputDirectory, relativePath);
        if (!outputBaseDir.exists()) {
            FileUtils.forceMkdir((File)outputBaseDir);
        }
        return new File(outputBaseDir, inputFile.getName());
    }

    private File getSourceDir() {
        return new File(this.sources.getDirectory());
    }

    private File[] getSourceFiles(FileSet src) throws IOException {
        FileSetManager fileSetManager = new FileSetManager();
        String[] includedFiles = fileSetManager.getIncludedFiles(src);
        File sourceDir = this.getSourceDir();
        File[] sourceFiles = new File[includedFiles.length];
        for (int i = 0; i < includedFiles.length; ++i) {
            sourceFiles[i] = new File(sourceDir, includedFiles[i]);
        }
        return sourceFiles;
    }

    private File[] getCssSourceFiles() throws IOException {
        return this.getSourceFiles(this.cssSources);
    }

    private File[] getJsSourceFiles() throws IOException {
        return this.getSourceFiles(this.sources);
    }
}

