/*
 * Decompiled with CFR 0.152.
 */
package com.github.pukkaone.gelf.logback;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.util.LevelToSyslogSeverity;
import ch.qos.logback.core.Context;
import com.github.pukkaone.gelf.logback.GelfAppender;
import com.github.pukkaone.gelf.logback.GelfMessageFactory;
import com.github.pukkaone.gelf.protocol.GelfMessage;
import java.util.Map;
import org.slf4j.Marker;

public class DefaultGelfMessageFactory
implements GelfMessageFactory {
    private static final String DEFAULT_SHORT_MESSAGE_PATTERN = "%m%nopex";
    private static final String DEFAULT_FULL_MESSAGE_PATTERN = "%xEx";
    private PatternLayout shortPatternLayout = new PatternLayout();
    private PatternLayout fullPatternLayout;

    public DefaultGelfMessageFactory() {
        this.shortPatternLayout.setContext((Context)new LoggerContext());
        this.shortPatternLayout.setPattern(DEFAULT_SHORT_MESSAGE_PATTERN);
        this.shortPatternLayout.start();
        this.fullPatternLayout = new PatternLayout();
        this.fullPatternLayout.setContext((Context)new LoggerContext());
        this.fullPatternLayout.setPattern(DEFAULT_FULL_MESSAGE_PATTERN);
        this.fullPatternLayout.start();
    }

    @Override
    public GelfMessage createMessage(GelfAppender appender, ILoggingEvent event) {
        Map mdc;
        Marker marker;
        GelfMessage message = new GelfMessage().setTimestampMillis(event.getTimeStamp());
        String originHost = appender.getOriginHost();
        if (originHost != null) {
            message.setHost(originHost);
        }
        if (appender.isLevelIncluded()) {
            message.setLevel(LevelToSyslogSeverity.convert((ILoggingEvent)event));
        }
        if (appender.isLocationIncluded()) {
            StackTraceElement locationInformation = event.getCallerData()[0];
            message.setFile(locationInformation.getFileName());
            message.setLine(locationInformation.getLineNumber());
        }
        if (appender.isLoggerIncluded()) {
            message.setLogger(event.getLoggerName());
        }
        if (appender.isMarkerIncluded() && (marker = event.getMarker()) != null) {
            message.setMarker(marker.getName());
        }
        if (appender.isMdcIncluded() && (mdc = event.getMDCPropertyMap()) != null) {
            for (Map.Entry entry : mdc.entrySet()) {
                this.addMessageField(mdc, message, (String)entry.getKey(), entry.getValue());
            }
        }
        if (appender.isThreadIncluded()) {
            message.setThread(event.getThreadName());
        }
        message.setShortMessage(this.shortPatternLayout.doLayout(event));
        String fullMessage = this.fullPatternLayout.doLayout(event);
        if (!fullMessage.isEmpty()) {
            message.setFullMessage(fullMessage);
        }
        message.setFacility(appender.getFacility());
        Map<String, String> fields = appender.getAdditionalFields();
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            this.addMessageField(fields, message, entry.getKey(), entry.getValue());
        }
        return message;
    }

    protected void addMessageField(Map<String, String> map, GelfMessage message, String key, Object value) {
        message.addField(key, value);
    }

    private void setMessagePattern(PatternLayout patternLayout, String messagePattern) {
        patternLayout.stop();
        patternLayout.setPattern(messagePattern);
        patternLayout.start();
    }

    public void setShortMessagePattern(String shortMessagePattern) {
        this.setMessagePattern(this.shortPatternLayout, shortMessagePattern);
    }

    public void setFullMessagePattern(String fullMessagePattern) {
        this.setMessagePattern(this.fullPatternLayout, fullMessagePattern);
    }
}

