/*
 * Decompiled with CFR 0.152.
 */
package com.github.pukkaone.gelf.protocol;

import com.github.pukkaone.gelf.protocol.GelfMessage;
import com.github.pukkaone.gelf.protocol.GelfSender;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.TimeoutException;

public class GelfAMQPSender
extends GelfSender {
    private volatile boolean shutdown = false;
    private ConnectionFactory factory = new ConnectionFactory();
    private Connection connection;
    private Channel channel;
    private String exchangeName;
    private String routingKey;
    private int maxRetries;

    public GelfAMQPSender(String host, String exchangeName, String routingKey, int maxRetries) throws IOException, URISyntaxException, NoSuchAlgorithmException, KeyManagementException {
        this.factory.setUri(host);
        this.exchangeName = exchangeName;
        this.routingKey = routingKey;
        this.maxRetries = maxRetries;
    }

    private synchronized Connection getConnection() throws IOException, TimeoutException {
        if (this.connection == null) {
            this.connection = this.factory.newConnection();
        }
        return this.connection;
    }

    private synchronized void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.connection = null;
        }
    }

    private synchronized Channel getChannel() throws IOException, TimeoutException {
        if (this.channel == null) {
            this.channel = this.getConnection().createChannel();
            this.channel.confirmSelect();
        }
        return this.channel;
    }

    private synchronized void closeChannel() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException | TimeoutException exception) {
                // empty catch block
            }
            this.channel = null;
        }
    }

    private ByteBuffer toAMQPBuffer(String json) {
        byte[] messageBytes = this.gzipMessage(json);
        ByteBuffer buffer = ByteBuffer.allocate(messageBytes.length);
        buffer.put(messageBytes);
        buffer.flip();
        return buffer;
    }

    @Override
    public boolean sendMessage(GelfMessage message) {
        if (this.shutdown || !message.isValid()) {
            return false;
        }
        String messageId = "gelf" + message.getTimestampMillis() + UUID.randomUUID();
        int tries = 0;
        while (true) {
            try {
                Channel channel = this.getChannel();
                AMQP.BasicProperties.Builder propertiesBuilder = new AMQP.BasicProperties.Builder();
                propertiesBuilder.contentType("application/json; charset=utf-8");
                propertiesBuilder.contentEncoding("gzip");
                propertiesBuilder.messageId(messageId);
                propertiesBuilder.timestamp(new Date(message.getTimestampMillis()));
                AMQP.BasicProperties properties = propertiesBuilder.build();
                channel.basicPublish(this.exchangeName, this.routingKey, properties, this.toAMQPBuffer(message.toJson()).array());
                channel.waitForConfirms();
                return true;
            }
            catch (IOException | InterruptedException | TimeoutException e) {
                this.closeChannel();
                this.closeConnection();
                if (++tries <= this.maxRetries || this.maxRetries < 0) continue;
                return false;
            }
            break;
        }
    }

    @Override
    public void close() {
        this.shutdown = true;
        this.closeChannel();
        this.closeConnection();
    }
}

